###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_php_mult_vuln_sep09.nasl 4930 2009-09-29 11:00:29Z sep $
#
# PHP Multiple Vulnerabilities - Sep09
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900871);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3291", "CVE-2009-3292", "CVE-2009-3293");
  script_bugtraq_id(36449);
  script_name("PHP Multiple Vulnerabilities - Sep09");
  desc = "
  Overview: This host is running PHP and is prone to multiple vulnerabilities.

  Vulnerability Insight:
  - An error in 'php_openssl_apply_verification_policy' function that does not
    properly perform certificate validation.
  - An input validation error exists in the processing of 'exif' data.
  - An unspecified error exists related to the sanity check for the color index
    in the 'imagecolortransparent' function.

  Impact:
  Successful exploitation will let the attackers to spoof certificates and can
  cause unknown impacts in the context of the web application.

  Impact Level: Application

  Affected Software/OS:
  PHP version prior to 5.2.11

  Fix: Upgrade to version 5.2.11 or later
  http://www.php.net/downloads.php

  References:
  http://secunia.com/advisories/36791
  http://www.php.net/releases/5_2_11.php
  http://www.php.net/ChangeLog-5.php#5.2.11
  http://www.openwall.com/lists/oss-security/2009/09/20/1

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.5
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of PHP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("gb_php_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

phpPort = get_http_port(default:80);
if(!phpPort){
  exit(0);
}

phpVer = get_kb_item("www/" + phpPort + "/PHP");
if(!isnull(phpVer))
{
  # Check for PHP version 5.2.11
  if(version_is_less(version:phpVer, test_version:"5.2.11")){
    security_hole(phpPort);
  }
}
