##############################################################################
#
#  Pi3Web ISAPI Requests Handling DoS Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/19/11
#
#  Revision: 1.0
#
#  Log: sghosal
#  Issue #0485
#
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program. 
##############################################################################

if(description)
{
  script_id(900402);
  script_bugtraq_id(32287);
  script_copyright("Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0");
  script_category(ACT_GATHER_INFO);
  script_family("Denial of Service");
  script_name("Pi3Web ISAPI Requests Handling DoS Vulnerability");
  script_summary("Check for vulnerable version of Pi3Web");
  desc = "
  Overview: 
  Pi3Web is prone to ISAPI Requests Handling DoS vulnerability.
  
  Vulnerability Insight:
  This vulnerability is caused due to insufficient checks on incoming HTTP 
  requests in the 'ISAPI' directory. This can be exploited via 'install.daf',
  'readme.daf', or 'users.txt' files in the affected directory.

  Impact:
  Successful exploitation will crash Pi3Web Server.

  Impact Level: Application/Network

  Affected Software/OS:
  Pi3Wed.org Pi3Web version 2.0.13 and prior on all running platforms.

  Workaround:
  - Disable ISAPI mapping in server configuration in Server Admin-> Mapping Tab.
  - Delete the users.txt, install.daf and readme.daf in ISAPI folder.

  References:
  http://milw0rm.com/exploits/7109/
  http://secunia.com/advisories/32696/
  http://pi3web.sourceforge.net/pi3web/files/
  http://www.securityfocus.com/bid/32287/info/

  CVSS Score:
    CVSS Base Score     : 8.8 (AV:N/AC:M/Au:NR/C:N/I:C/A:C)
    CVSS Temporal Score : 7.5
  Risk factor: High";

  script_description(desc);
  script_dependencies("http_version.nasl");
  exit(0);
}


include("http_func.inc");

port = get_http_port(default:80);
if(!port){
  port = 8080;
}

if(get_port_state(port))
{
  request = http_get(item:"/", port:port);
  response = http_send_recv(port:port, data:request);
  if(response == NULL){
    exit(0); 
  }
  if("Pi3Web" >< response)
  {
    if(safe_checks())
    {
      pattern = "Pi3Web/(^[01](\..*)|2\.0(\.[0-3])?)";
      if(egrep(pattern:pattern, string:response)){
        security_warning(port);
        exit(0);
      }
    }
    req = http_get(item:"/isapi/users.txt", port:port);
    resp = http_send_recv(port:port, data:req);
    if("500 Internal Error" >< resp){
      security_warning(port);
    }
  }
}
