###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_pidgin_msnslp_dos_vuln_lin.nasl 4203 2009-08-24 16:08:14Z aug $
#
# Pidgin MSN SLP Packets Denial Of Service Vulnerability (Linux)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900920);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2694");
  script_bugtraq_id(36071);
  script_name("Pidgin MSN SLP Packets Denial Of Service Vulnerability (Linux)");
  desc = "

  Overview: This host has Pidgin installed and is prone to Denial of Service
  vulnerability.

  Vulnerability Insight:
  An error in the 'msn_slplink_process_msg()' function while processing
  malformed MSN SLP packets which can be exploited to overwrite an
  arbitrary memory location.

  Impact:
  Attackers can exploit this issue to execute arbitrary code, corrupt memory
  and cause the application to crash.

  Impact Level: Application

  Affected Software/OS:
  Pidgin version prior to 2.5.9 on Linux.

  Fix: Upgrade to Pidgin version 2.5.9
  http://pidgin.im/download

  References:
  http://secunia.com/advisories/36384
  http://www.pidgin.im/news/security/?id=34
  http://www.vupen.com/english/advisories/2009/2303

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Pidgin");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_pidgin_detect_lin.nasl");
  script_require_keys("Pidgin/Lin/Ver");
  exit(0);
}


include("version_func.inc");

pidginVer = get_kb_item("Pidgin/Lin/Ver");
if(pidginVer != NULL)
{
  if(version_is_less(version:pidginVer, test_version:"2.5.9")){
    security_hole(0);
  }
}
