###############################################################################
# OpenVAS Vulnerabilities Test
# $Id: secpod_pidgin_mult_dos_vuln_lin.nasl 4622 2009-09-15 15:29:58Z sep $
#
# Pidgin Multiple Denial Of Service Vulnerabilities (Linux)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900941);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2703", "CVE-2009-3083", "CVE-2009-3084",
                "CVE-2009-3085");
  script_bugtraq_id(36277);
  script_name("Pidgin Multiple Denial Of Service Vulnerabilities (Linux)");
  desc = "
  Overview: This host has Pidgin installed and is prone to multiple Denial of
  Service vulnerabilities.

  Vulnerabilities Insight:
  - An error in libpurple/protocols/irc/msgs.c in the IRC protocol plugin in
    libpurple can trigger a NULL-pointer dereference when processing TOPIC
    messages which lack a topic string.
  - An error in the 'msn_slp_sip_recv' function in libpurple/protocols/msn/slp.c
    in the MSN protocol can trigger a NULL-pointer dereference via an SLP invite
    message missing expected fields.
  - An error in the 'msn_slp_process_msg' function in libpurple/protocols/msn/
    slpcall.c in the MSN protocol when converting the encoding of a handwritten
    message can be exploited by improper utilisation of uninitialised variables.
  - An error in the XMPP protocol plugin in libpurple is fails to handle an
    error IQ stanza during an attempted fetch of a custom smiley is processed
    via XHTML-IM content with cid: images.

  Impact:
  Attackers can exploit this issue to execute arbitrary code, corrupt memory
  and cause the application to crash.

  Impact Level: System/Application

  Affected Software/OS:
  Pidgin version prior to 2.6.2 on Linux.

  Fix: Upgrade to Pidgin version 2.6.2
  http://pidgin.im/download

  References:
  http://secunia.com/advisories/36601
  http://developer.pidgin.im/ticket/10159
  http://www.pidgin.im/news/security/?id=37
  http://www.pidgin.im/news/security/?id=38
  http://www.pidgin.im/news/security/?id=39
  http://www.pidgin.im/news/security/?id=40

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Pidgin");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_pidgin_detect_lin.nasl");
  script_require_keys("Pidgin/Lin/Ver");
  exit(0);
}


include("version_func.inc");

pidginVer = get_kb_item("Pidgin/Lin/Ver");

if(pidginVer != NULL)
{
  if(version_is_less(version:pidginVer, test_version:"2.6.2")){
    security_warning(0);
  }
}
