#############################################################################
#
#  Pidgin NSS plugin SSL Certificate Validation Security Bypass Vulnerability (Win)
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/06
#
#  Revision: 1.2 
#
#  Log: schandan
#  Issue #0089
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900020);
 script_bugtraq_id(30553);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("$Revision: 1.2 $");
 script_category(ACT_GATHER_INFO);
 script_family("General");
 script_name("Pidgin NSS plugin SSL Certificate Validation Security Bypass Vulnerability (Win)");
 script_summary("Check for vulnerable version of Pidgin");
 desc = "
 Overview : The host is running Pidgin, which is prone to Security Bypass
 Vulnerability

 Vulnerability Insight:

        The application fails to properly validate SSL (Secure Sockets Layer) 
        certificate from a server.

        Impact : Man-in-the-middle attacks or identity impersonation attacks are possible. 

 Impact Level : Network

 Affected Software/OS:
        Pidgin Version 2.4.3 and prior on Windows (All).

 Fix : Apply the patch from,
 http://developer.pidgin.im/attachment/ticket/6500/nss-cert-verify.patc h 

 References : http://developer.pidgin.im/ticket/6500

 CVSS Score :
        CVSS Base Score     : 7.8 (AV:N/AC:M/Au:NR/C:C/I:P/A:N)
        CVSS Temporal Score : 6.1
 Risk factor : High";

 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 pidginVer = registry_get_sz(item:"DisplayVersion",
	     key:"SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Pidgin");

 if(egrep(pattern:"^([01]\..*|2\.([0-3](\..*)?|4(\.[0-3])?))$", string:pidginVer)){
 	security_warning(0);
 }
