###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_qemu_detect_lin.nasl 5475 2009-10-30 17:40:29Z oct $
#
# QEMU Version Detection (Linux)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) SecPod http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900969);
  script_version("$Revision: 1.0 $");
  script_name("QEMU Version Detection (Linux)");
  desc = "
  Overview: This script is detects the installed version of QEMU and
  sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set KB for the version of QEMU");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

qemuSock = ssh_login_or_reuse_connection();
if(!qemuSock){
  exit(0);
}

qemuName = find_file(file_name:"qemu", file_path:"/", useregex:TRUE,
                     regexpar:"$", sock:qemuSock);

foreach binaryName (qemuName)
{
  binaryName = chomp(binaryName);
  qemuVer = get_bin_version(full_prog_name:binaryName, sock:qemuSock,
                            version_argv:"-help",
                            ver_pattern:"QEMU PC emulator version ([0-9.]+)");
  if(qemuVer[1] != NULL){
    set_kb_item(name:"QEMU/Lin/Ver", value:qemuVer[1]);
  }
}
ssh_close_connection();
