###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_realplayer_smil_bof_lin.nasl 6968 2010-01-29 12:45:02Z jan $
#
# RealNetworks RealPlayer SMIL file BOF Vulnerability (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(902109);
  script_version("$Revision: 6608 $: 1.0");
  script_cve_id("CVE-2009-4257");
  script_bugtraq_id(37880);
  script_name("RealNetworks RealPlayer SMIL file BOF Vulnerability (Linux)");
  desc = "
  Overview: This host is installed with RealPlayer which is prone to Buffer
  overflow vulnerability.

  Vulnerability Insight:
  The buffer overflow error exists when processing a malformed 'SMIL file'.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes within
  the context of the application and can cause heap overflow or cause remote
  code execution.

  Affected Software/OS:
  RealPlayer versions 10.x and 11.0.0 on Linux platforms.

  Fix:  Upgrade to RealPlayer version 11.0.5 or later.
  For Updates Refer, http://www.real.com/player

  References:
  http://secunia.com/advisories/38218
  http://xforce.iss.net/xforce/xfdb/55794
  http://www.vupen.com/english/advisories/2010/0178
  http://service.real.com/realplayer/security/01192010_player/en/

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.9
  Risk factor: High ";

  script_description(desc);
  script_summary("Check for the version of RealPlayer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("secpod_realplayer_detect_lin.nasl");
  script_require_keys("RealPlayer/Linux/Ver");
  exit(0);
}


include("version_func.inc");

rpVer = get_kb_item("RealPlayer/Linux/Ver");
if(isnull(rpVer)){
  exit(0);
}

if((rpVer =~ "^10\.*") ||
   version_is_equal(version:rpVer, test_version:"11.0.0")){
  security_hole(0);
}
