#############################################################################
#
#  RealPlayer SWF Frame Handling Buffer Overflow Vulnerability (Win)
#
#  Copyright: SecPod
#
#  Date Written: 2008/07/28
#
#  Revision: 1.1 
#
#  Log: schandan
#  Issue #
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900015);
 script_bugtraq_id(30370);
 script_cve_id("CVE-2007-5400");
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("$Revision: 1.1 $");
 script_category(ACT_GATHER_INFO);
 script_family("Buffer overflow");
 script_name("RealPlayer SWF Frame Handling Buffer Overflow Vulnerability (Win)");
 script_summary("Check for the vulnerable version of RealPlayer");
 desc = "
 Overview : This Remote host is running with RealPlayer, which is prone to
 buffer overflow vulnerability.

 Vulnerability Insight :

        The flaw exist due to a design error in handling/parsing of frames
        in Shockwave Flash (SWF) files.

        Impact : Successful exploitation could allow remote attackers to
        execute arbitrary code on a user's system.

 Impact Level : Application/System.

 Affected Software/OS :
        RealPlayer Version 10, 10.5 and 11 on Windows (All).

 Fix : Upgrade to the latest version available,
 http://service.real.com/realplayer/security/07252008_player/en/

 References : http://secunia.com/advisories/27620/

 CVSS Score :
        CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
        CVSS Temporal Score : 5.0
 Risk factor : Medium";
 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 realPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
		                "\App Paths\realplay.exe", item:"Path");
 if(!realPath){
	exit(0);
 }

 realExe = realPath + "\realplay.exe";

 share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:realExe);
 file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:realExe);

 name   =  kb_smb_name();
 login  =  kb_smb_login();
 pass   =  kb_smb_password();
 domain =  kb_smb_domain();
 port   =  kb_smb_transport();

 soc = open_sock_tcp(port);
 if(!soc){
        exit(0);
 }

 r = smb_session_request(soc:soc, remote:name);
 if(!r){
        exit(0);
 }

 prot = smb_neg_prot(soc:soc);
 if(!prot){
        exit(0);
 }

 r = smb_session_setup(soc:soc, login:login, password:pass,
                       domain:domain, prot:prot);
 if(!r){
        exit(0);
 }

 uid = session_extract_uid(reply:r);

 r = smb_tconx(soc:soc, name:name, uid:uid, share:share);
 tid = tconx_extract_tid(reply:r);
 if(!tid){
        exit(0);
 }

 fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
 if(!fid){
        exit(0);
 }

 fsize = smb_get_file_size(socket:soc, uid:uid, tid:tid, fid:fid);
 off = fsize - 90000;

 while(fsize != off)
 {
        data = ReadAndX(socket:soc, uid:uid, tid:tid, count:16384, off:off);
        data = str_replace(find:raw_string(0), replace:"", string:data);
        version = strstr(data, "ProductVersion");
        if(!version){
                off += 16383;
        }
        else break;
 }

 if(!version){
        exit(0);
 }

 v = "";
 for(i = strlen("ProductVersion"); i < strlen(version); i++)
 {
        if((ord(version[i]) < ord("0") ||
            ord(version[i]) > ord("9")) && version[i] != "."){
                break;
        }
        else
                v += version[i];
 }

 # Grep for RealPlayer versions <= 11 (6.0.14.806, 6.0.14.738-6.0.14.802) and
 # RealPlayer version <= 10 (6.0.12.1040-6.0.12.1663, 6.0.12.1675, 6.0.12.1698,
 # and 6.0.12.1741)
 if(ereg(pattern:"^([0-5]\..*|6\.0\.([0-9]\..*|1?[01]\..*|12\.(10[4-9]?[0-9]?" +
		 "|1[1-5][0-9][0-9]|16[0-5][0-9]|166[0-3]|1675|1698|1741)|" +
		 "14\.(73[89]|7[4-9][0-9]|80[0-2]|806)))$",
 	 string:v)){
        security_warning(0);
 }
