##############################################################################
#
#  Serv-U File Renaming Directory Traversal and 'STOU' DoS Vulnerabilities
#
#  Copyright: SecPod
#
#  Date Written: 2008/10/07
#
#  Revision: 1.1
#
#  Log : ssharath
#  Issue #0309
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
  script_id(900149);
  script_bugtraq_id(31563);
  script_copyright("Copyright (C) 2008 SecPod");
  script_version("Revision: 1.1 ");
  script_category(ACT_GATHER_INFO);
  script_family("Denial of Service");
  script_name("Serv-U File Renaming Directory Traversal and 'STOU' DoS Vulnerabilities");
  script_summary("Check for vulnerable version of Serv-U FTP Server");
  desc = "
  Overview : The host is running Serv-U FTP Server, which is prone to Directory
  Traversal and Denial of Service Vulnerabilities. 

  The flaws are due to,
  - error in handling 'STOU' FTP command. It can exhaust available CPU
    resources when exploited through a specially crafted argument vaule.
  - input validation error in the FTP service when renaming files which can be
    exploited to overwrite or rename files via directory traversal attacks.

  Impact :
  Successful exploitation allows an attacker to write arbitrary files to 
  locations outside of the application's current directory, and deny the service.

  Impact Level : Application

  Affected Software/OS :
  RhinoSoft Serv-U FTP Server 7.3.0.0 and prior 

  Fix : No solution/patch is available as on 07th October, 2008.

  References :
  http://milw0rm.com/exploits/6660
  http://secunia.com/advisories/32150/
  http://xforce.iss.net/xforce/xfdb/45653

  CVSS Score :
    CVSS Base Score     : 7.5 (AV:N/AC:M/Au:SI/C:P/I:P/A:C)
    CVSS Temporal Score : 6.7
  Risk factor : High";

  script_description(desc);
  script_dependencies("secpod_reg_enum.nasl", "find_service.nes");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("ftp_func.inc");
include("secpod_smb_func.inc");

ftpPort = get_kb_item("Services/ftp");
if(!ftpPort){
  ftpPort = 21;
}

if(!get_port_state(ftpPort)){
  exit(0);
}

banner = get_ftp_banner(port:ftpPort);
if("Serv-U" >!< banner){
  exit(0);
}

if(egrep(pattern:"Serv-U FTP Server v7\.[0-2]", string:banner)){
  security_warning(ftpPort);
  exit(0);
}

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

servPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                               "\Uninstall\Serv-U_is1", item:"DisplayIcon");
if(!servPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*",replace:"\1$",string:servPath);
file = ereg_replace(pattern:"[A-Z]:(.*)",replace:"\1",string:servPath);

soc = open_sock_tcp(port);
if(!soc){
  exit(0);
}

r = smb_session_request(soc:soc, remote:name);
if(!r){
  close(soc);
  exit(0);
}

prot = smb_neg_prot(soc:soc);
if(!prot){
  close(soc);
  exit(0);
}

r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain,
                      prot:prot);
if(!r){
  close(soc);
  exit(0);
}

uid = session_extract_uid(reply:r);
if(!uid){
  close(soc);
  exit(0);
}

r = smb_tconx(soc:soc, name:name, uid:uid, share:share);
if(!r){
  close(soc);
  exit(0);
}

tid = tconx_extract_tid(reply:r);
if(!tid){
  close(soc);
  exit(0);
}

fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
if(!fid){
  close(soc);
  exit(0);
}

ftpVer = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid, verstr:"prod");
close(soc);

if(!ftpVer){
  exit(0);
}

if(egrep(pattern:"^(7\.3(\.0(\.0)?)?)$", string:ftpVer)){
  security_warning(ftpPort);
}
