###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_seamonkey_mult_vuln_dec09_lin.nasl 6283 2009-12-21 19:05:33Z dec $
#
# Seamonkey Multiple Vulnerabilities Dec-09 (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(902007);
  script_version("$Revision: 6243 $: 1.0");
  script_cve_id("CVE-2009-3388", "CVE-2009-3389", "CVE-2009-3979", "CVE-2009-3980",
                "CVE-2009-3981", "CVE-2009-3982", "CVE-2009-3983", "CVE-2009-3984",
                "CVE-2009-3985", "CVE-2009-3986", "CVE-2009-3987");
  script_bugtraq_id(37369, 37368, 37361, 37362, 37363, 37364, 37366, 37367, 37370,
                    37365, 37360);
  script_name("Seamonkey Multiple Vulnerabilities Dec-09 (Linux)");
  desc = "
  Overview: The host is installed with Seamonkey browser and is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  For more information about vulnerabilities on Seamonkey, refer the links
  mentioned in references.

  Impact:
  Successful exploitation will let the attacker to conduct spoofing attacks,
  bypass certain security restrictions, manipulate certain data, disclose
  sensitive information, or compromise a user's system.

  Impact Level: Application/System

  Affected Software/OS:
  Seamonkey version prior to 2.0.1 on Linux.

  Fix:
  Upgrade to Seamonkey version 2.0.1,
  http://www.seamonkey-project.org/releases/

  References:
  http://secunia.com/advisories/37699
  http://www.vupen.com/english/advisories/2009/3547
  http://www.mozilla.org/security/announce/2009/mfsa2009-65.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-66.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-67.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-68.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-69.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-70.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-71.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Seamonkey");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("gb_seamonkey_detect_lin.nasl");
  script_require_keys("Seamonkey/Linux/Ver");
  exit(0);
}


include("version_func.inc");

# Seamonkey Check
smVer = get_kb_item("Seamonkey/Linux/Ver");
if(smVer)
{
  # Grep for Seamonkey version prior to 2.0.1
  if(version_is_less(version:smVer, test_version:"2.0.1")){
    security_hole(0);
  }
}
