###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_serendipity_file_upload_vuln.nasl 6412 2009-12-31 16:40:29Z dec $
#
# Serendipity File Extension Processing Arbitrary File Upload Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901091);
  script_version("$Revision: 6302 $: 1.0");
  script_cve_id("CVE-2009-4412");
  script_name("Serendipity File Extension Processing Arbitrary File Upload Vulnerability");
  desc = "
  Overview: This host is running Serendipity and is prone to arbitrary file upload
  vulnerability.

  Vulnerability Insight:
  The flaw is due to an input validation error in the file upload functionality
  when processing a file with a filename containing multiple file extensions.

  Impact:
  Successful exploitation will let the attacker to upload PHP scripts and execute
  arbitrary commands on a web server with a specific configuration.

  Impact Level: Application

  Affected Software/OS:
  Serendipity version prior to 1.5 on all platforms.

  Fix: Upgrade to Serendipity version 1.5 or later.
  For Updates Refer, http://www.s9y.org/12.html

  References:
  http://secunia.com/advisories/37830
  http://xforce.iss.net/xforce/xfdb/54985
  http://www.vupen.com/english/advisories/2009/3626
  http://www.openwall.com/lists/oss-security/2009/12/21/1

  CVSS Score:
    CVSS Base Score      : 6.0 (AV:N/AC:M/Au:SI/C:P/I:P/A:P)
    CVSS Temporal Score  : 4.4
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Serendipity");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("serendipity_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

serPort = get_http_port(default:80);
if(!serPort){
  exit(0);
}

serVer = get_kb_item("www/"+ serPort + "/serendipity");
if(!serVer){
  exit(0);
}

ver = eregmatch(pattern:"^(.+) under (/.*)$", string:serVer);
if(ver[1] != NULL)
{
  # Check for Serendipity version < 1.5
  if(version_is_less(version:ver[1], test_version:"1.5")){
    security_warning(serPort);
  }
}
