###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_silc_prdts_detect.nasl 4736 2009-09-24 15:29:24Z sep $
#
# SILC Products Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900950);
  script_version("Revision: 1.0 $");
  script_name("SILC Products Version Detection");
  desc  = "
  Overview: This script detects the installed version of SILC Products
  and sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets KB for the version of SILC Products");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

silc_sock = ssh_login_or_reuse_connection();
if(!silc_sock){
  exit(0);
}

# Set the SILC-Client version.
paths = find_file(file_name:"silc", file_path:"/", useregex:TRUE,
                                   regexpar:"$", sock:silc_sock);
foreach clntBin (paths)
{
  clntVer= get_bin_version(full_prog_name:chomp(clntBin), sock:silc_sock,
               version_argv:"--version", ver_pattern:"Client ([0-9.]+)");

  if(clntVer[1] != NULL){
    set_kb_item(name:"SILC/Client/Ver", value:clntVer[1]);
  }
}
ssh_close_connection();
