###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_sjs_access_manager_info_disc_vuln.nasl 3866 2009-08-25 14:50:29Z aug $
#
# Sun Java System Access Manager Information Disclosure vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900195);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2713");
  script_bugtraq_id(35961);
  script_name("Sun Java System Access Manager Information Disclosure vulnerability");
  desc = "

  Overview: The host is running Java System Access Manager and is prone to
  information disclosure vulnerability.

  Vulnerability Insight:
  Error in CDCServlet component is caused when 'Cross Domain Single Sign On'
  (CDSSO) is enabled which does not ensure that 'policy advice' is presented
  to the correct client, which can be exploited via unspecified vectors.

  Impact:
  Successful exploitation could allow remote unprivileged user to gain the
  sensitive information.

  Impact Level: Application

  Affected Software/OS:
  Java System Access Manager version 7.0 2005Q4 and 7.1

  Fix: Apply the security updates.
  http://sunsolve.sun.com/search/document.do?assetkey=1-21-126356-03-1

  *****
  NOTE: Ignore this warning if above mentioned patch is already applied.
  *****

  References:
  http://secunia.com/advisories/36167
  http://www.vupen.com/english/advisories/2009/2176
  http://sunsolve.sun.com/search/document.do?assetkey=1-66-255968-1

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 3.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Java System Access Manager");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_sjs_access_manager_detect.nasl");
  script_require_ports("Services/www", 8080);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

am_port = get_http_port(default:8080);
if(!am_port){
  am_port = 8080;
}

amVer = get_kb_item("www/" + am_port + "/Sun/JavaSysAccessMang");
amVer = eregmatch(pattern:"^(.+) under (/.*)$", string:amVer);

# Check for Java Access Manager version 7.0 2005Q4 or 7.1
if(amVer[1] =~ "7.1|7.0.2005Q4"){
  security_warning(am_port);
}
