###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_slurm_detect.nasl 2975 2009-06-18 22:18:29Z jun $
#
# SLURM Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900374);
  script_version("$Revision: 1.0 $");
  script_name("SLURM Version Detection");
  desc = "
  Overview: This script detects the installed version of SLURM and
  sets the reuslt in KB.

  Risk Factor: Informational";

  script_description(desc);
  script_summary("Set KB for the version of SLURM");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

slurm_sock = ssh_login_or_reuse_connection();
if(!slurm_sock){
  exit(0);
}

paths = find_bin(prog_name:"slurmctld", sock:slurm_sock);
foreach binName (paths)
{
  slurmVer = get_bin_version(full_prog_name:chomp(binName), sock:slurm_sock,
                             version_argv:"-V",
                             ver_pattern:"slurm ([0-9]\.[0-9.]+-?((rc)?[0-9]+)?)");
  if(slurmVer[1] != NULL)
  {
    slurmVer = ereg_replace(pattern:"-", replace:".", string:slurmVer[1]);
    if(slurmVer != NULL)
    {
      set_kb_item(name:"SLURM/Ver", value:slurmVer);
      ssh_close_connection();
      exit(0);
    }
  }
}

ssh_close_connection();
