##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_sun_virtualbox_detect_win.nasl 5792 2009-11-19 14:30:24Z nov $
#
# Sun VirtualBox Version Detection (Win)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901053);
  script_version("$Revision: 1.0 $");
  script_name("Sun VirtualBox Version Detection (Win)");
  desc = "
  Overview: This script detects the installed version of Sun VirtualBox
  and sets the result in KB.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set KB for the version of Sun VirtualBox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

# Check for both products Sun VirtuaBox and Sun xVm VirtuaBox
if(!registry_key_exists(key:"SOFTWARE\Sun\VirtualBox") &&
   !registry_key_exists(key:"SOFTWARE\Sun\xVM VirtualBox")){
  exit(0);
}

path = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:path))
{
  vbname = registry_get_sz(key:path + item, item:"DisplayName");
  if("Sun VirtualBox" >< vbname)
  {
    vmVer = registry_get_sz(key:path + item, item:"DisplayVersion");
    if(vmVer){
      set_kb_item(name:"Sun/VirtualBox/Win/Ver", value:vmVer);
    }
  }
  else if("Sun xVM VirtualBox" >< vbname)
  {
    xvmVer = registry_get_sz(key:path + item, item:"DisplayVersion");
    if(xvmVer){
      set_kb_item(name:"Sun/xVM-VirtualBox/Win/Ver", value:xvmVer);
    }
  }
}
