###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_surgemail_detect.nasl 4586 2009-09-14 10:02:24Z sep $
#
# SurgeMail Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900839);
  script_version("$Revision: 1.0 $");
  script_name("SurgeMail Version Detection");
  desc = "
  Overview: This script detects the installed version of SurgeMail
  and sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set KB for the version of SurgeMail");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("http_version.nasl", "find_service.nes");
  exit(0);
}


include("http_func.inc");

function SurgeMailSetVer(banner)
{
  version = eregmatch(pattern:"Version ([0-9.]+)([a-z][0-9]?(-[0-9])?)?",
                      string:banner);
  if(version[1])
  {
    if(!isnull(version[2]))
      version = version[1] + "." + version[2];
    else
      version = version[1];

    version = ereg_replace(pattern:"-", replace:".", string:version);

    if(version) {
      set_kb_item(name:"SurgeMail/Ver", value:version);
    }
  }
}


surge_banner = get_http_banner(port:7110);

if("surgemail" >< surge_banner){
  SurgeMailSetVer(banner:surge_banner);
  exit(0);
}

# Grep for Default Port
surgemail_port = get_http_port(default:7026);

if(!surgemail_port){
  surgemail_port = 7026;
}

# Check for Default Port Status
if(!get_port_state(surgemail_port))
{
  exit(0);
}

sndReq = http_get(item:"/", port:surgemail_port);
rcvRes = http_send_recv(port:surgemail_port, data:sndReq);

if(egrep(pattern:"SurgeMail", string:rcvRes, icase:1))
{
  smtpPort = get_kb_item("Services/smtp");
  if(!smtpPort)
    smtpPort = 25;

  imapPort = get_kb_item("Services/imap");
  if(!imapPort)
    imapPort = 143;

  popPort = get_kb_item("Services/pop3");
  if(!popPort)
    popPort = 110;

  foreach port (make_list(smtpPort, imapPort, popPort))
  {
    surge_banner = get_kb_item(string("Banner/", port));

    if(surge_banner =~ "surgemail"){
      SurgeMailSetVer(banner:surge_banner);
      exit(0);
    }
  }
}
