###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_symantec_prdts_detect.nasl 1022 2009-03-26 19:06:24Z mar $
#
# Symantec Product(s) Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Update By: Antu Sanadi <santu@secpod.com> on 2010-02-25
# Updated to detect and set KB for EndPoint Priotection IM Manager
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900332);
  script_version("Revision$: 1.1");
  script_name("Symantec Product(s) Version Detection");
  desc = "
  Overview: This script detects the installed version of Symantec Product(s)
  and sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets Symantec Product(s) Version in the KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

if(!registry_key_exists(key:key)){
  exit(0);
}

foreach item (registry_enum_keys(key:key))
{
  symantecName = registry_get_sz(key:key + item, item:"DisplayName");
  if("Symantec pcAnywhere" >< symantecName)
  {
    pcawVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(pcawVer){
      set_kb_item(name:"Symantec/pcAnywhere/Ver", value:pcawVer);
    }
  }

  if("Norton Internet Security" >< symantecName)
  {
    nisVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(nisVer){
      set_kb_item(name:"Norton/InetSec/Ver", value:nisVer);
    }
  }

  # Setting KB for Endpoint Protection
  if("Symantec Endpoint Protection" >< symantecName)
  {
    nisVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(nisVer){
      set_kb_item(name:"Symantec/Endpoint/Protection", value:nisVer);
    }
  }

  # Setting KB for IMManager
  if("IMManager" >< symantecName)
  {
    imPath = registry_get_sz(key:key + item, item:"InstallSource");
    if(!isnull(imPath))
    {
      imPath = imPath - "\temp" + "IMLogicAdminService.exe";
      share = ereg_replace(pattern:"([A-Za-z]):.*", replace:"\1$", string:imPath);
      file =  ereg_replace(pattern:"[A-Za-z]:(.*)", replace:"\1", string:imPath);

      imVer = GetVer(file:file, share:share);
      if(!isnull(imVer)){
        set_kb_item(name:"Symantec/IM/Manager", value:imVer);
      }
    }
  }
}
