###############################################################################
# OpenVAS Vulnerabilities Test
# $Id: secpod_systemtap_mult_dos_vuln.nasl 5480 2009-10-28 15:29:58Z oct $
#
# SystemTap Unprivileged Mode Multiple Denial Of Service Vulnerabilities
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901043);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2911");
  script_bugtraq_id(36778);
  script_name("SystemTap Unprivileged Mode Multiple Denial Of Service Vulnerabilities");
  desc = "
  Overview: This host has SystemTap installed and is prone to multiple Denial of
  Service vulnerabilities.

  Vulnerabilities Insight:
  Multiple errors occur when SystemTap is running in 'unprivileged' mode.
  - Error within the handling of the unwind table and CIE/CFI records
  - A buffer overflow error when processing a long number of parameters
  - A stack overflow when processing DWARF information

  Impact:
  Attackers can exploit this issue to execute arbitrary code and cause a denial
  of service or compromise a vulnerable system.

  Impact Level: System/Application.

  Affected Software/OS:
  SystemTap version 1.0 and prior.

  Fix: Apply the patch from,
  https://bugzilla.redhat.com/attachment.cgi?id=365293
  https://bugzilla.redhat.com/attachment.cgi?id=365294
  https://bugzilla.redhat.com/attachment.cgi?id=365413

  *****
  NOTE: Ignore this warning, if above mentioned patch is already applied.
  *****

  References:
  http://www.vupen.com/english/advisories/2009/2989
  https://bugzilla.redhat.com/show_bug.cgi?id=529175
  http://www.openwall.com/lists/oss-security/2009/10/21/1
  http://sources.redhat.com/bugzilla/show_bug.cgi?id=10750

  CVSS Score:
    CVSS Base Score      : 1.9 (AV:L/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score  : 1.4
  Risk factor: Informational";

  script_description(desc);
  script_summary("Check for the version of SystemTap");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_systemtap_detect.nasl");
  script_require_keys("SystemTap/Ver");
  exit(0);
}


include("version_func.inc");

systapVer = get_kb_item("SystemTap/Ver");

if(systapVer != NULL)
{
  if(version_is_less_equal(version:systapVer, test_version:"1.0")){
    security_warning(0);
  }
}
