###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_tfm_mmplayer_m3u_bof_vuln.nasl 3596 2009-07-24 16:52:02Z jul $
#
# TFM MM Player '.m3u' Buffer Overflow Vulnerability - July-09
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900597);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2566");
  script_name("TFM MMPlayer '.m3u' Buffer Overflow Vulnerability - July-09");
  desc = "

  Overview: This host is installed with TFM MMPlayer and is prone to stack
  based Buffer Overflow bulnerability.

  Vulnerability Insight:
  This flaw is due to improper bounds checking when processing '.m3u' files
  and can be exploited via crafted '.m3u' playlist file containing an overly
  long string.

  Impact:
  Successful exploitation allows the attacker to execute arbitrary code on
  the system or cause the application to crash.

  Impact Level: Application

  Affected Software/OS:
  TFM MMPlayer version 2.0 to 2.2.0.30 on Windows.

  Fix: No solution or patch is available as on th 24th July, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.tfm.ro/mmplayer/top.html

  References:
  http://secunia.com/advisories/35605
  http://www.milw0rm.com/exploits/9047
  http://xforce.iss.net/xforce/xfdb/51442
  
  CVSS Score:
    CVSS Base Score      : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C) 
    CVSS Temporal Score  : 8.4 
  Risk factor: Critical"; 
  
  script_description(desc);
  script_summary("Check for the Version of TFM MMPlayer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_tfm_mmplayer_detect.nasl");
  script_require_keys("TFM/MMPlayer/Ver");
  exit(0);
}


include("version_func.inc");

mmplayerVer = get_kb_item("TFM/MMPlayer/Ver");
if(mmplayerVer != NULL)
{
  # Grep for MMPlayer version 2.0 <= 2.2.0.30
  if(version_in_range(version:mmplayerVer, test_version:"2.0",
                                           test_version2:"2.2.0.30")){
    security_hole(0);
  }
}
