###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_thegreenbow_ipsec_vpn_client_detect.nasl 4204 2009-08-26 10:14:02Z aug $
#
# TheGreenBow IPSec VPN Client Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900921);
  script_version("$Revision: 1.0 $");
  script_name("TheGreenBow IPSec VPN Client Version Detection");
  desc = "

  Overview: This script detects the version of TheGreenBow IPSec VPN Client
  and sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets KB for the version of TheGreenBow IPSec VPN Client");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

if(!registry_key_exists(key:key)){
    exit(0);
}

foreach item (registry_enum_keys(key:key))
{
  vpnName = registry_get_sz(key:key + item, item:"DisplayIcon");
  if("TheGreenBow VPN" >< vpnName)
  {
    share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:vpnName);
    file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:vpnName);

    vpnVer = GetVer(file:file, share:share);
    if(vpnVer != NULL)
    {
      set_kb_item(name:"TheGreenBow-IPSec-VPN-Client/Ver", value:vpnVer);
      exit(0);
    }
  }
}
