###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_thegreenbow_ipsec_vpn_client_dos_vuln.nasl 4204 2009-08-26 11:52:24Z aug $
#
# TheGreenBow IPSec VPN Client Denial Of Service Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900922);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2918");
  script_name("TheGreenBow IPSec VPN Client Denial Of Service Vulnerability");
  desc = "

  Overview:
  This host has TheGreenBow IPSec VPN Client installed and is prone to Denial
  of Service vulnerability.

  Vulnerability Insight:
  The flaw is due to a NULL-pointer dereference error in 'tgbvpn.sys' driver
  when processing x80000034 IOCTLs.

  Impact:
  Attackers can exploit this issue via crafted requests to x80000034 IOCTL
  probably involving an input or output buffer size of 0 to cause  denial
  of service.

  Impact Level: Application

  Affected Software/OS:
  TheGreenBow IPSec VPN Client version 4.61.003 and prior on Windows.

  Fix:
  No solution or patch is available as on 26th August, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.thegreenbow.com/vpn.html

  References:
  http://secunia.com/advisories/36332/
  http://www.vupen.com/english/advisories/2009/2294
  http://www.securityfocus.com/archive/1/archive/1/505816/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 2.1 (AV:L/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 1.9
  Risk factor: Low";

  script_description(desc);
  script_summary("Check for the version of TheGreenBow IPSec VPN Client");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_thegreenbow_ipsec_vpn_client_detect.nasl");
  script_require_keys("TheGreenBow-IPSec-VPN-Client/Ver");
  exit(0);
}


include("version_func.inc");

vpnPort = 500;
if(!get_udp_port_state(vpnPort)){
  exit(0);
}

vpnVer = get_kb_item("TheGreenBow-IPSec-VPN-Client/Ver");
if(!vpnVer){
  exit(0);
}

# Check for TheGreenBow IPSec VPN Client version <= 4.61.033 (4.6.1.3)
if(version_is_less_equal(version:vpnVer, test_version:"4.6.1.3")){
  security_warning(port:vpnPort, proto:"udp");
}
