###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_thunderbird_mult_vuln_apr09_lin.nasl 1903 2009-04-24 15:36:26Z apr $
#
# Mozilla Thunderbird Multiple Vulnerabilities Apr-09 (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900345);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1302", "CVE-2009-1303", "CVE-2009-1304", "CVE-2009-1305",
                "CVE-2009-1306", "CVE-2009-1307", "CVE-2009-1308", "CVE-2009-1309");
  script_bugtraq_id(34656);
  script_name("Mozilla Thunderbird Multiple Vulnerabilities Apr-09 (Linux)");
  desc = "

  Overview: The host is installed with Mozilla Thunderbird and is prone to
  multiple vulnerabilities.

  Vulnerability Insight:
  For more information about vulnerabilities on Thunderbird, go through the links
  mentioned in references.

  Impact:
  Successful exploitation could result in Information Disclosure, XSS, Script
  Injection, Memory Corruption, CSRF, Arbitrary JavaScript code execution or
  can cause denial of service attacks.

  Impact Level: System/Application

  Affected Software/OS:
  Thunderbird version prior to 2.0.0.22 on Linux.

  Fix: Upgrade to Thunderbird version 2.0.0.22
  http://www.mozillamessaging.com/en-US/thunderbird/all.html

  References:
  http://secunia.com/advisories/34780
  http://www.mozilla.org/security/announce/2009/mfsa2009-14.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-16.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-17.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-18.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-19.html

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.5
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Thunderbird");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("gb_thunderbird_detect_lin.nasl");
  script_require_keys("Thunderbird/Linux/Ver");
  exit(0);
}


include("version_func.inc");

tbVer = get_kb_item("Thunderbird/Linux/Ver");
if(!tbVer){
  exit(0);
}

# Grep for Thunderbird version prior to 2.0.0.22
if(version_is_less(version:tbVer, test_version:"2.0.0.22")){
  security_hole(0);
}
