##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_tightvnc_detect_win.nasl 987 2009-02-27 16:50:24Z feb $
#
# TightVNC Version Detection (Win)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900472);
  script_version("$Revision: 1.0 $");
  script_name("TightVNC Version Detection (Win)");
  desc = "
  Overview : This script finds the installed version of TightVNC and
  saves the version in KB.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set Version of TightVNC in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

if(!registry_key_exists(key:key)){
    exit(0);
}

foreach item (registry_enum_keys(key:key))
{
  tvncName = registry_get_sz(key:key + item, item:"DisplayName");
  if("TightVNC" >< tvncName)
  {
    tvncVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(tvncVer != NULL){
      set_kb_item(name:"TightVNC/Win/Ver", value:tvncVer);
    }
    exit(0);
  }
}
