##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_tikiwiki_detect.nasl 4254 2009-08-26 16:04:29Z aug $
#
# TikiWiki Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################

if(description)
{
  script_id(901001);
  script_version("$Revision: 1.0 $");
  script_name("TikiWiki Version Detection");
  desc = "

  Overview: This script detects the installed version of TikiWiki and
  sets the result in KB.

  Risk factor:Informational";

  script_description(desc);
  script_summary("Set KB for the Version of TikiWiki");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

tikiPort = get_http_port(default:80);
if(!tikiPort){
  tikiPort = 80;
}

if(!get_port_state(tikiPort)){
  exit(0);
}

foreach dir (make_list("/tikiwiki", "/tiki", "/wiki", "/", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/tiki-index.php"), port:tikiPort);
  rcvRes = http_send_recv(port:tikiPort, data:sndReq);
  if("TikiWiki" >< rcvRes)
  {
    tikiVer = eregmatch(pattern:"TikiWiki ([0-9.]+)", string:rcvRes);

    if(tikiVer == NULL)
    {
      sndReq = http_get(item:string(dir, "/README"), port:tikiPort);
      rcvRes = http_send_recv(port:tikiPort, data:sndReq);
      tikiVer = eregmatch(pattern:"[v|V]ersion ([0-9.]+)", string:rcvRes);
    }

    if(tikiVer[1] != NULL){
      set_kb_item(name:"www/"+ tikiPort + "/TikiWiki",
                  value:tikiVer[1] + " under " + dir);
    }
  }
}
