###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_transmission_csrf_vuln.nasl 2466 2009-05-28 21:25:29Z may $
#
# Transmission Client Cross Site Request Forgery Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900715);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1757");
  script_name("Transmission Client Cross Site Request Forgery Vulnerability");
  desc = "

  Overview: This host is installed with Transmission Client and is prone to
  Cross Site Request Forgery Vulnerability.

  Vulnerability Insight:
  This flaw is due to Cross-site request forgery error which causes hijacking
  the authentication of unspecified victims via unknown vectors.

  Impact:
  Successful exploitation will let the attacker hijack the authenticated
  sessions of unspecified users.

  Affected Software/OS:
  Transmission Client version 1.5 before 1.53 and 1.6 before 1.61

  Fix:
  Upgrade to version 1.53 or 1.61
  http://www.transmissionbt.com/download.php

  References:
  http://www.openwall.com/lists/oss-security/2009/05/21/1

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:N/C:P/I:P/A:P)
    CVSS Temporal Score : 5.0
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Transmission Client");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_transmission_detect.nasl");
  script_require_keys("Transmission/Ver");
  exit(0);
}


include("version_func.inc");

transVer = get_kb_item("Transmission/Ver");
if(!transVer){
  exit(0);
}

# Grep for Transmission clent versions
if(version_in_range(version:transVer, test_version:"1.5", test_version2:"1.52") ||
   version_in_range(version:transVer, test_version:"1.6", test_version2:"1.60")){
  security_warning(0);
}
