###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_vlc_media_player_detect_lin.nasl 1115 2009-03-24 18:47:29Z mar $
#
# VLC Media Player Version Detection (Lin)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900529);
  script_version("$Revision: 1.0 $");
  script_name("VLC Media Player Version Detection (Lin)");
  desc = "
  Overview: This script detects the installed version of VLC Media Player
  and sets the result in KB.

  Risk Factor: Informational";

  script_description(desc);
  script_summary("Set KB for the version of VLC Media Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

vlcBinPath = find_bin(prog_name:"vlc", sock:sock);
foreach binPath (vlcBinPath)
{
  vlcVer = get_bin_version(full_prog_name:chomp(binPath), version_argv:"--version",
                           ver_pattern:"VLC version ([0-9\.]+[a-z]?)", sock:sock);
  if(vlcVer[1] != NULL)
  {
    set_kb_item(name:"VLCPlayer/Lin/Ver", value:vlcVer[1]);
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
