###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_vmware_server_mult_xss_vuln_dec09_lin.nasl 6251 2009-12-18 18:03:40Z dec $
#
# VMware Server Multiple Cross-Site Scripting Vulnerabilities (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900899);
  script_version("$Revision: 6233 $: 1.0");
  script_cve_id("CVE-2009-3731");
  script_bugtraq_id(37346);
  script_name("VMware Server Multiple Cross-Site Scripting Vulnerabilities (Linux)");
  desc = "
  Overview: The host is installed with VMWare Server that is vulnerable to
  multiple Cross-Site Scripting vulnerabilities.

  Vulnerability Insight:
  - Multiple vulnerabilities can be exploited to disclose sensitive information,
    conduct cross-site scripting attacks, manipulate certain data, bypass certain
    security restrictions, cause a DoS, or compromise a user's system.
  - Certain unspecified input passed to WebWorks help pages is not properly
    sanitised before being returned to the user. This can be exploited to execute
    arbitrary HTML and script code in a user's browser session in context of an
    affected site.

  Impact:
  Successful exploitation will lets attackers to cause a Denial of Service, or
  compromise a user's system.

  Impact Level: System/Application

  Affected Software/OS:
  VMware Server version 2.0.2 on Linux.

  Fix:
  Apply patch,
  http://kb.vmware.com/kb/1016594

  *****
  NOTE: Ignore this warning, if above mentioned patch is manually applied.
  *****

  References:
  http://secunia.com/advisories/37460/
  http://www.webworks.com/Security/2009-0001/
  http://www.vmware.com/security/advisories/VMSA-2009-0017.html

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.4
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of VMware Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_vmware_prdts_detect_lin.nasl");
  script_require_keys("VMware/Server/Linux/Ver", "VMware/Linux/Installed");
  exit(0);
}


include("version_func.inc");

if(!get_kb_item("VMware/Linux/Installed")){
  exit(0);
}

# VMware Server
vmserVer = get_kb_item("VMware/Server/Linux/Ver");
if(vmserVer)
{
  if(version_is_equal(version:vmserVer, test_version:"2.0.2")){
    security_warning(0);
  }
}
