##############################################################################
#
#  Microsoft Windows NSlookup.exe Remote Code Execution Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/18
#
#  Revision: 1.1
#
#  Log: ssharath
#  Issue #0108
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900108);
 script_bugtraq_id(30636);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("$Revision: 1.1 $");
 script_category(ACT_GATHER_INFO);
 script_family("Windows");
 script_name("Microsoft Windows NSlookup.exe Remote Code Execution Vulnerability");
 script_summary("Check for vulnerable version of Microsoft Windows");
 desc = "
 Overview : The host is running Windows XP SP2, which prone to remote code
 execution vulnerability.

 Vulnerability Insight :

        The flaw is due to an unspecified error in 'NSlookup.exe' file,
        which could be exploited by attackers.	

        Impact : Successfull exploitation causes remote code execution, and 
        Denial-of-Service.

 Impact Level : System

 Affected Software/OS :
        Microsoft Windows 2K and XP.

 Fix : No solution/patch is available as on 14th August, 2008. Information
 regarding this issue will be updated soon once the details are available.
 For update refer, http://www.microsoft.com/en/us/default.aspx

 References :
 http://www.securityfocus.com/bid/30636/solution
 http://www.nullcode.com.ar/ncs/crash/nsloo.htm

 CVSS Score :
        CVSS Base Score     : 8.3 (AV:N/AC:M/Au:NR/C:P/I:P/A:C)
        CVSS Temporal Score : 6.7
 Risk factor : High";

 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");
 include("secpod_smb_func.inc");

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 winPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
 if(!winPath){
	exit(0);
 }

 winPath += "\nslookup.exe";
 share = ereg_replace(pattern:"([A-Z]):.*",replace:"\1$",string:winPath);
 file = ereg_replace(pattern:"[A-Z]:(.*)",replace:"\1",string:winPath);

 name = kb_smb_name();
 domain = kb_smb_domain();
 login = kb_smb_login();
 pass = kb_smb_password();
 port = kb_smb_transport();
 soc = open_sock_tcp(port);
 if(!soc){
        exit(0);
 }

 r = smb_session_request(soc:soc, remote:name);
 if(!r){
        exit(0);
 }

 prot = smb_neg_prot(soc:soc);
 if(!prot){
        exit(0);
 }

 r = smb_session_setup(soc:soc, login:login, password:pass,
                       domain:domain, prot:prot);
 if(!r){
        exit(0);
 }
 
 uid = session_extract_uid(reply:r);
 
 r = smb_tconx(soc:soc, name:name, uid:uid, share:share);

 tid = tconx_extract_tid(reply:r);
 if(!tid){
        exit(0);
 }
 
 fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
 if(!fid){
        exit(0);
 }

 winVer = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid, verstr:"prod", offset:50000);

 if(egrep(pattern:"^5\.(0?1\.2600\.([01]?[0-9]?[0-9]?[0-9]|20[0-9][0-9]|21[0-7]" +
		  "[0-9]|2180)|0?0\.2195\.([0-5]?[0-9]?[0-9]?[0-9]|6[0-5][[0-9]" +
		  "[0-9]|66[0-5][0-9]|666[0-3]))$", string:winVer)){
	security_warning(port:port);
 }
