###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_winamp_detect.nasl 898 2009-01-28 20:02:24Z jan $
#
# Winamp Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900196);
  script_version("Revision: 1.0 $");
  script_name("Winamp Version Detection");
  desc = "
  Overview: This script detects the installed version of Winamp and sets the
  version in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets the KB for the version of Winamp");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

winampPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                                 "\App Paths\winamp.exe", item:"Path");
if(!winampPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*",replace:"\1$", string:winampPath);
file = ereg_replace(pattern:"[A-Z]:(.*)",replace:"\1",
                    string:winampPath + "\winamp.exe");

winampVer = GetVer(share:share, file:file);
if(winampVer){
  set_kb_item(name:"Winamp/Version", value:winampVer);
}
