###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_wireshark_pcnfsd_dos_vuln_win.nasl 2505 2009-06-01 10:39:24Z may $
#
# Wireshark PCNFSD Dissector Processing Denial of Service Vulnerability (Win)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900559);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1829");
  script_bugtraq_id(35081);
  script_name("Wireshark PCNFSD Dissector Denial of Service Vulnerability (Win)");
  desc = "

  Overview: The remote host is installed with Wireshark and is prone to
  denial of service vulnerability.

  Vulnerability Insight:
  The flaw is due to an error in the PCNFSD dissector when processing specially
  crafted large PCNFSD packets.

  Impact:
  Successful exploitation will let the user crash the application to cause
  denial of service condition.

  Impact Level: Application

  Affected Software/OS:
  Wireshark version 0.8.20 through 1.0.7 on Windows.

  Fix: Upgrade to Wireshark 1.0.8
  http://www.wireshark.org/download.html

  References:
  http://www.vupen.com/english/advisories/2009/1408

  CVSS Score:
    CVSS Base Score      : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score  : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Wireshark");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_wireshark_detect_win.nasl");
  exit(0);
}


include("version_func.inc");

sharkVer = get_kb_item("Wireshark/Win/Ver");
if(!sharkVer){
  exit(0);
}

if(version_in_range(version:sharkVer, test_version:"0.8.20", test_version2:"1.0.7")){
  security_warning(0);
}
