###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_wordpress_mult_vuln_aug09.nasl 4079 2009-08-19 11:53:09Z aug $
#
# WordPress 'wp-admin' Multiple Vulnerabilities - Aug09
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900915);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2853", "CVE-2009-2854");
  script_bugtraq_id(35935);
  script_name("WordPress 'wp-admin' Multiple Vulnerabilities - Aug09");
  desc = "

  Overview:
  The host is running WordPress and is prone to multiple vulnerabilities.

  Vulnerability Insight:
  - Application fails to properly sanitize user supplied input via a direct
    request to admin-footer.php, edit-category-form.php, edit-form-advanced.php,
    edit-form-comment.php, edit-link-category-form.php, edit-link-form.php,
    edit-page-form.php, and edit-tag-form.php in wp-admin/.
  - Application fails to check capabilities for certain actions, it can be
    exploited to cause unauthorized edits or additions via a direct request to
    edit-comments.php, edit-pages.php, import.php, edit-category-form.php,
    edit-link-category-form.php, edit-tag-form.php, export.php, link-add.php
    or edit.php in wp-admin/.

  Impact:
  Attackers can exploit this issue by sending malicious request to several
  scripts in the wp-admin directory to gain access to administrative functions
  which may allow them to obtain sensitive information or elevate privileges.

  Impact Level: System/Application

  Affected Software/OS:
  WordPress version prior to 2.8.3 on all running platform.

  Fix: Update to Version 2.8.3
  http://wordpress.org/download/

  References:
  http://core.trac.wordpress.org/changeset/11768
  http://core.trac.wordpress.org/changeset/11769
  http://wordpress.org/development/2009/08/wordpress-2-8-3-security-release/

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of WordPress");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_wordpress_detect_900182.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

# Get for WordPress Default Port
wpPort = get_http_port(default:80);
if(!wpPort){
  exit(0);
}

# Get KB for WordPress Version
wpVer = get_kb_item("www/" + wpPort + "/WordPress");
wpVer = eregmatch(pattern:"^(.+) under (/.*)$", string:wpVer);

if(wpVer[1] != NULL)
{
  # Check for WordPress Version prir to 2.8.3
  if(version_is_less(version:wpVer[1], test_version:"2.8.3")){
    security_hole(wpPort);
  }
}
