###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_wordpress_php_code_exec_vuln_900183.nasl 740 2008-12-24 16:47:24Z dec $
#
# WordPress 'wp-admin/options.php' Remote Code Execution Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright (c) 2008 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if(description)
{
  script_id(900183);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5695");
  script_bugtraq_id(27633);
  script_name("WordPress 'wp-admin/options.php' Remote Code Execution Vulnerability");
  desc = "

  Overview: The host is running WordPress and is prone to Remote Code
  Execution vulnerability.

  Vulnerability Insight:
  The flaw is caused due to error under 'wp-admin/options.php' file. These
  can be exploited by using valid user credentials with 'manage_options' and
  upload_files capabilities.

  Impact:
  Successful exploitation allows remote attackers to execute arbitrary code by
  uploading a PHP script and adding this script pathname to active_plugins.

  Impact Level: System/Application

  Affected Software/OS:
  WordPress, WordPress prior to 2.3.3
  WordPress, WordPress MU prior to 1.3.2

  Fix: Upgrade to version 1.3.2 and 2.3.3 or later
  http://mu.wordpress.org/download/

  References:
  http://secunia.com/advisories/28789
  http://www.milw0rm.com/exploits/5066
  http://mu.wordpress.org/forums/topic.php?id=7534&page&replies=1

  CVSS Score:
    CVSS Base Score     : 8.5 (AV:N/AC:M/Au:SI/C:C/I:C/A:C)
    CVSS Temporal Score : 6.7
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of WordPress");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_wordpress_detect_900182.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

wpPort = get_http_port(default:80);
if(!wpPort){
  exit(0);
}

wpVer = get_kb_item("www/" + wpPort + "/WordPress");
wpVer = eregmatch(pattern:"^(.+) under (/.*)$", string:wpVer);
if(wpVer[1] != NULL)
{
  # Grep for version 2.3.2 and prior
  if(version_is_less_equal(version:wpVer[1], test_version:"2.3.2")){
    security_hole(wpPort);
  }
}
