###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_xampp_mult_csrf_vuln.nasl 1065 2009-03-23 15:13:23Z mar $
#
# XAMPP Multiple Cross-Site Request Forgery Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900527);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-6498", "CVE-2008-6499");
  script_name("XAMPP Multiple Cross-Site Request Forgery Vulnerability");
  desc = "

  Overview: The host is installed with XAMPP and is prone to multiple
  cross-site request forgery vulnerability.

  Vulnerability Insight:
  Multiple flaws are due to,
  - Lack of input validation checking for the user-supplied data provided
    to 'security/xamppsecurity.php' which lets change admin password through
    CSRF attack.
  - Input passed to some certain parameters like 'dbserver', 'host', 'password',
    'database' and 'table' in not properly sanitised before being returned to a
    user.

  Impact:
  Successful exploitation will let the attacker execute crafted malicious
  queries in the vulnerable parameters or can change admin authentication data
  via crafted CSRF queries.

  Impact Level: Application/Network

  Affected Software/OS:
  XAMPP version 1.6.8 or prior on all platforms.

  Fix: No solution or patch is available as on 30th March, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.apachefriends.org/en/xampp.htm

  References:
  http://secunia.com/advisories/32134
  http://www.milw0rm.com/exploits/7384
  http://securityreason.com/securityalert/5434

 CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.1
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of XAMPP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("secpod_xampp_detect.nasl");
  script_require_ports("Services/www", 80, 8080);
  exit(0);
}


include("version_func.inc");
include("http_func.inc");

xamppPort = get_kb_item("Services/www");
if(!xamppPort){
  exit(0);
}

xamppVer = get_kb_item("www/" + xamppPort + "/XAMPP");
if(!xamppVer){
  exit(0);
}

if(version_is_less_equal(version:xamppVer, test_version:"1.6.8")){
  security_hole(xamppPort);
}
