#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10247);
 script_bugtraq_id(1);
 script_version ("$Revision: 4336 $");
 script_cve_id("CVE-1999-0095");
 
 name = "Sendmail DEBUG";
 script_name(name);
 
 desc = "
Your MTA accepts the DEBUG mode.

This mode is dangerous as it allows remote
users to execute arbitrary commands as root
without the need to log in.

Solution : Upgrade your MTA.

Risk factor : High"; 
	


 script_description(desc);
		    
 
 summary = "Checks for the presence of the DEBUG mode"; 
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright("This script is Copyright (C) 1999 Renaud Deraison");
 
 family = "SMTP problems";
 script_family(family);
 script_dependencie("find_service.nes", "smtpserver_detect.nasl");
 script_require_keys("SMTP/sendmail");
 script_exclude_keys("SMTP/wrapped");

 script_require_ports("Services/smtp", 25);
 
 exit(0);
}

#
# The script code starts here
#

include("smtp_func.inc");

port = get_kb_item("Services/smtp");
if(!port)port = 25;
if(!get_port_state(port))exit(0);
if(get_kb_item("SMTP/wrapped"))exit(0);

soc = open_sock_tcp(port);
if(soc)
 {
  b = smtp_recv_banner(socket:soc);

  s = string("debug\r\n");
  send(socket:soc, data:s);
  r = recv_line(socket:soc, length:1024);
  r = tolower(r);

  
  if(("200 debug set" >< r))security_hole(port);
  close(soc);
}
