# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#
# References:
# From: "Michal Zalewski" <lcamtuf@echelon.pl>
# To: bugtraq@securityfocus.com
# CC: sendmail-security@sendmail.org
# Subject: RAZOR advisory: multiple Sendmail vulnerabilities

if(description)
{
 script_id(11087);
 script_bugtraq_id(3378);
 script_cve_id("CVE-2001-0714");
 script_version ("$Revision: 4336 $");
 
 name = "Sendmail queue manipulation & destruction";
 script_name(name);
 
 desc = "
The remote sendmail server, according to its version number,
might be vulnerable to a queue destruction when a local user
runs
	sendmail -q -h1000

If you system does not allow users to process the queue (which
is the default), you are not vulnerable.

Solution : upgrade to the latest version of Sendmail or 
do not allow users to process the queue (RestrictQRun option)
Risk factor : Low
Note : This vulnerability is _local_ only"; 



 script_description(desc);
		    
 
 summary = "Checks the version number for 'queue destruction'"; 
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright("This script is Copyright (C) 2002 Michel Arboi");
 
 family = "SMTP problems";
 script_family(family);
 script_dependencie("find_service.nes","smtpserver_detect.nasl");
 script_require_keys("SMTP/sendmail","smtpserver_detect.nasl");
 script_require_ports("Services/smtp", 25);
 exit(0);
}

#

include("smtp_func.inc");

port = get_kb_item("Services/smtp");
if(!port) port = 25;

banner = get_smtp_banner(port: port);
if(! banner || "Switch-" >< banner ) exit(0);

if(egrep(pattern:".*Sendmail.*8\.(([0-9]\..*)|(1[01]\..*)|(12\.0)).*",
	string:banner))
	security_warning(port);
