###############################################################################
# OpenVAS Vulnerability Test
# $Id: simple_machines_forum_37182.nasl 6041 2009-12-02 18:43:26Z mime $
#
# Simple Machines Forum Multiple Security Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100371);
 script_bugtraq_id(37182);
 script_version ("1.0-$Revision: 6041 $");

 script_name("Simple Machines Forum Multiple Security Vulnerabilities");

desc = "Overview:
Simple Machines Forum is prone to multiple security vulnerabilities:

- A remote PHP code-execution vulnerability
- Multiple cross-site scripting vulnerabilities
- Multiple cross-site request-forgery vulnerabilities
- An information-disclosure vulnerability
- Multiple denial-of-service vulnerabilities

 Attackers can exploit these issues to execute arbitrary script code
 within the context of the webserver, perform unauthorized actions on
 behalf of legitimate users, compromise the affected application,
 steal cookie-based authentication credentials, obtain information
 that could aid in further attacks or cause denial-of-service
 conditions.

Please note some of these issues may already be described in other
BIDs. This BID will be updated if further analysis confirms this.

These issues affect Simple Machines Forum 2.0 RC2. Some of these
issues also affect version 1.1.10.

Solution:
Reportedly, the vendor fixed some of the issues in the release 1.1.11.

References:
http://www.securityfocus.com/bid/37182
http://www.simplemachines.org/
http://code.google.com/p/smf2-review/issues/list

Risk factor : High";

 script_description(desc);
 script_summary("Determine if Simple Machines Forum is prone to	multiple security vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("gb_simple_machines_forum_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/SMF")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

 if(version_is_equal(version: vers, test_version: "1.1.10") ||
    version_is_equal(version: vers, test_version: "2.0.RC2")) {
        security_hole(port:port);
        exit(0);
  }
}

exit(0);
