# OpenVAS
# $Id$
# Description: Set information for smb authorization in KB.
#
# Authors:
# Jan-Oliver Wagner <jan-oliver.wagner@intevation.de>
#
# Copyright:
# Copyright (C) 2008 Intevation GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or, at your option, any later version as published by the
# Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.

# The two entries "SMB/dont_send_ntlmv1" and "SMB/dont_send_in_cleartext"
# are not handled here yet. They are still managed in logins.nasl.

# Unlike the old code in logins.nasl, here only a single
# set of credentials in managed. Thus the strange name
# used for the KB.

if(description)
{
 script_id(90023);
 script_version ("1.0");
 name = "SMB Authorization";

 script_name(name);

 desc = "
This script allows users to enter the information
required to authorize and login via SMB.

These data are stored in the knowledge base
and used by other tests.

Risk factor: None";

 script_description(desc);

 summary = "Sets SMB authorization";
 script_summary(summary);

 script_category(ACT_INIT);

 script_copyright("Copyright 2008 Intevation GmbH, License: GNU GPLv2+");
 family = "Credentials";
 script_family(family);

 script_add_preference(name:"SMB login:", type:"entry", value:"");
 script_add_preference(name:"SMB password:", type:"password", value:"");
 script_add_preference(name:"SMB domain (optional):", type:"entry", value:"");

 exit(0);
}

smb_login = script_get_preference("SMB login:");
smb_password = script_get_preference("SMB password:");
smb_domain = script_get_preference("SMB domain (optional):");

if (smb_login) set_kb_item(name: "SMB/login_filled/0", value: smb_login);
if (smb_password) set_kb_item(name:"SMB/password_filled/0", value:smb_password);
if (smb_domain) set_kb_item(name: "SMB/domain_filled/0", value: smb_domain);
