###############################################################################
# OpenVAS Vulnerability Test
# $Id: smtp_relay.nasl 6984 2010-03-17 12:20:23Z mime $
#
# SMTP Open Relay Test
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
 script_id(100073);
 script_version ("1.0");
 name = "Mail relaying";
 script_name(name);
 
 desc = "

 Overview:
  The remote SMTP server is insufficiently protected against relaying
  This means that spammers might be able to use your mail server 
  to send their mails to the world.

 Solution:
  Improve the configuration of your SMTP server so that your SMTP server 
  cannot be used as a relay any more.

 Risk factor : Medium";

 script_description(desc);
 summary = "Checks if the mail server can be used as a open relay"; 
 script_summary(summary);
 script_category(ACT_GATHER_INFO);
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 family = "SMTP problems";
 script_family(family);
 script_dependencie("smtpserver_detect.nasl","sendmail_expn.nasl","smtp_settings.nasl");
 script_exclude_keys("SMTP/wrapped", "SMTP/qmail");
 script_require_ports("Services/smtp", 25);
 exit(0);
}

include("smtp_func.inc");
include("misc_func.inc");
include("network_func.inc");

if(islocalhost())exit(0);
if(is_private_addr()) exit(0);

port = get_kb_item("Services/smtp");
if(!port) port = 25;

if(get_kb_item('SMTP/'+port+'/broken'))exit(0);
if(!get_port_state(port))exit(0);

domain = get_kb_item("Settings/third_party_domain");
if(!domain)domain = 'example.com';

soc = smtp_open(port: port, helo: NULL);
if(!soc)exit(0);
 
src_name = this_host_name();
FROM = string('openvas@', src_name);
TO = string('openvas@', domain);

send(socket: soc, data: strcat('EHLO ', src_name, '\r\n'));
answer = smtp_recv_line(socket: soc);

if("250" >!< answer)exit(0);

  mf = strcat('MAIL FROM: <', FROM , '>\r\n');
  send(socket: soc, data: mf);
  l = smtp_recv_line(socket: soc);

  if(! l || l =~ '^5[0-9][0-9]')
  {
    exit(0);
  }
  else
  {
    rt = strcat('RCPT TO: <', TO , '>\r\n');
    send(socket: soc, data: rt);
    l = smtp_recv_line(socket: soc);

    if (l =~ '^2[0-9][0-9]')
    {
      data=string("data\r\n");
      send(socket: soc, data: data);
      data_rcv = smtp_recv_line(socket: soc);
      
      if(egrep(pattern:"3[0-9][0-9]", string:data_rcv)) {

        send(socket: soc, data: string("OpenVAS-Relay-Test\r\n.\r\n"));
	mail_send = smtp_recv_line(socket: soc);
	
	if("250" >< mail_send) {
          security_warning(port:port);
          set_kb_item(name:"SMTP/" + port + "/spam", value:TRUE);
          set_kb_item(name:"SMTP/spam", value:TRUE);
          smtp_close(socket: soc);
          exit(0);
	}  
      
      }
    }
    smtp_close(socket: soc);
   }

exit(0);
