#
# This script was written by Paul Johnston of Westpoint Ltd <paul@westpoint.ltd.uk>
#
# See the Nessus Scripts License for details
#

if(description)
{
  script_id(11195);
  script_version ("$Revision: 4336 $");
  script_cve_id("CVE-2002-1357", "CVE-2002-1358", "CVE-2002-1359", "CVE-2002-1360");

  name = "SSH Multiple Vulns";
  script_name(name);

  desc = "
 According to its banner, the remote SSH server is vulnerable to one or 
 more of the following vulnerabilities:

CVE-2002-1357 (incorrect length)
CVE-2002-1358 (lists with empty elements/empty strings)
CVE-2002-1359 (large packets and large fields)
CVE-2002-1360 (string fields with zeros)

Some of these vulnerabilities may allow remote attackers to execute 
arbitrary code with the privileges of the SSH process, usually root.

Solution : Upgrade your SSH server to an unaffected version

Risk factor : High";

  script_description(desc);

  summary = "SSH Multiple Vulnerabilities 16/12/2002";
  script_summary(summary);

  script_category(ACT_GATHER_INFO); 
  script_copyright("This script is Copyright (C) 2002 Paul Johnston, Westpoint Ltd");
  script_family("Gain a shell remotely");
  script_require_ports("Services/ssh", 22);
  script_dependencie("ssh_detect.nasl");

  exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/ssh");
if (!port) port = 22;

banner = get_kb_item("SSH/banner/" + port);
if ( ! banner ) exit(0);


#
# SSH-2.0-3.2.0 F-Secure SSH Windows NT Server
# versions up to 3.1.* affected
#
if(ereg(pattern:"^SSH-2.0-([12]\..*|3\.[01]\..*) F-Secure SSH", string:banner, icase:TRUE))
{ 
  security_hole(port);
}

#
# SSH-2.0-3.2.0 SSH Secure Shell Windows NT Server
# versions up to 3.1.* affected
#
if(ereg(pattern:"^SSH-2.0-([12]\..*|3\.[01]\..*) SSH Secure Shell", string:banner, icase:TRUE))
{ 
  security_hole(port);
}

#
# SSH-1.99-Pragma SecureShell 3.0
# versions up to 2.* affected
#
if(ereg(pattern:"^SSH-1.99-Pragma SecureShell ([12]\..*)", string:banner, icase:TRUE))
{ 
  security_hole(port);
}
