# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory SUSE-SA:2009:010 (kernel)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63467);
 script_cve_id("CVE-2008-5079", "CVE-2008-5700", "CVE-2008-5702", "CVE-2009-0028", "CVE-2009-0029", "CVE-2009-0031", "CVE-2009-0065", "CVE-2009-0269", "CVE-2009-0322");
 script_version ("$");
 name["english"] = "SuSE Security Advisory SUSE-SA:2009:010 (kernel)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing updates announced in
advisory SUSE-SA:2009:010.

This update fixes several security issues and lots of bugs in the
openSUSE 11.1 kernel.  For details, please visit the referenced
security advisories.

The Linux kernel on openSUSE 11.1 was updated to the stable version
2.6.27.19 and is also now at the same kernel as we are planning to
ship with SUSE Linux Enterprise (Server/Desktop) 11.

This update introduces kABI changes, so all kernel module packages
also need to be rebuilt and reapplied. Rebuilt NVIDIA KMPs already
are provided by NVIDIA, ATI and Madwifi KMPs will follow soon.

Solution:
Update your system with the packages as indicated in
the referenced security advisory.

https://secure1.securityspace.com/smysecure/catid.html?in=SUSE-SA:2009:010

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "SuSE Security Advisory SUSE-SA:2009:010 (kernel)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-base", rpm:"kernel-debug-base~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-debug-extra", rpm:"kernel-debug-extra~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-default", rpm:"kernel-default~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-default-base", rpm:"kernel-default-base~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-default-extra", rpm:"kernel-default-extra~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-pae", rpm:"kernel-pae~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-pae-base", rpm:"kernel-pae-base~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-pae-extra", rpm:"kernel-pae-extra~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-syms", rpm:"kernel-syms~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-trace", rpm:"kernel-trace~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-trace-base", rpm:"kernel-trace-base~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-trace-extra", rpm:"kernel-trace-extra~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-vanilla", rpm:"kernel-vanilla~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-xen", rpm:"kernel-xen~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-xen-base", rpm:"kernel-xen-base~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-xen-extra", rpm:"kernel-xen-extra~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-docs", rpm:"kernel-docs~2.6.3~3.13.5", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-kdump", rpm:"kernel-kdump~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-ppc64", rpm:"kernel-ppc64~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-ppc64-base", rpm:"kernel-ppc64-base~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-ppc64-extra", rpm:"kernel-ppc64-extra~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kernel-ps3", rpm:"kernel-ps3~2.6.27.19~3.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
