# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-757-1 (gs-gpl)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63856);
 script_cve_id("CVE-2007-6725", "CVE-2008-6679", "CVE-2009-0196", "CVE-2009-0583", "CVE-2009-0584", "CVE-2009-0792", "CVE-2009-0189", "CVE-2008-5259", "CVE-2009-0190", "CVE-2009-0796", "CVE-2009-1185", "CVE-2009-1186");
 script_version ("$");
 name = "Ubuntu USN-757-1 (gs-gpl)";
 script_name(name);

 desc = "The remote host is missing an update to gs-gpl
announced via advisory USN-757-1.

Details follow:

It was discovered that Ghostscript contained a buffer underflow in its
CCITTFax decoding filter. If a user or automated system were tricked into
opening a crafted PDF file, an attacker could cause a denial of service or
execute arbitrary code with privileges of the user invoking the program.
(CVE-2007-6725)

It was discovered that Ghostscript contained a buffer overflow in the
BaseFont writer module. If a user or automated system were tricked into
opening a crafted Postscript file, an attacker could cause a denial of
service or execute arbitrary code with privileges of the user invoking the
program. (CVE-2008-6679)

It was discovered that Ghostscript contained additional integer overflows
in its ICC color management library. If a user or automated system were
tricked into opening a crafted Postscript or PDF file, an attacker could
cause a denial of service or execute arbitrary code with privileges of the
user invoking the program. (CVE-2009-0792)

Alin Rad Pop discovered that Ghostscript contained a buffer overflow in the
jbig2dec library. If a user or automated system were tricked into opening a
crafted PDF file, an attacker could cause a denial of service or execute
arbitrary code with privileges of the user invoking the program.
(CVE-2009-0196)

USN-743-1 provided updated ghostscript and gs-gpl packages to fix two
security vulnerabilities. This update corrects the same vulnerabilities in
the gs-esp package.

Original advisory details:
 It was discovered that Ghostscript contained multiple integer overflows in
 its ICC color management library. If a user or automated system were
 tricked into opening a crafted Postscript file, an attacker could cause a
 denial of service or execute arbitrary code with privileges of the user
 invoking the program. (CVE-2009-0583)

 It was discovered that Ghostscript did not properly perform bounds
 checking in its ICC color management library. If a user or automated
 system were tricked into opening a crafted Postscript file, an attacker
 could cause a denial of service or execute arbitrary code with privileges
 of the user invoking the program. (CVE-2009-0584)

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  gs-esp                          8.15.2.dfsg.0ubuntu1-0ubuntu1.2
  gs-gpl                          8.15-4ubuntu3.3

Ubuntu 8.04 LTS:
  libgs8                          8.61.dfsg.1-1ubuntu3.2

Ubuntu 8.10:
  libgs8                          8.63.dfsg.1-0ubuntu6.4

In general, a standard system upgrade is sufficient to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-757-1

Risk factor : High";

 script_description(desc);

 summary = "Ubuntu USN-757-1 (gs-gpl)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Ubuntu Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gs", ver:"8.15-4ubuntu3.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-esp", ver:"8.15.2.dfsg.0ubuntu1-0ubuntu1.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-gpl", ver:"8.15-4ubuntu3.3", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ghostscript-doc", ver:"8.61.dfsg.1-1ubuntu3.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-gpl", ver:"8.61.dfsg.1-1ubuntu3.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs", ver:"8.61.dfsg.1-1ubuntu3.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgs-esp-dev", ver:"8.61.dfsg.1-1ubuntu3.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-aladdin", ver:"8.61.dfsg.1-1ubuntu3.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-common", ver:"8.61.dfsg.1-1ubuntu3.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-esp-x", ver:"8.61.dfsg.1-1ubuntu3.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-esp", ver:"8.61.dfsg.1-1ubuntu3.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ghostscript-x", ver:"8.61.dfsg.1-1ubuntu3.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ghostscript", ver:"8.61.dfsg.1-1ubuntu3.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgs-dev", ver:"8.61.dfsg.1-1ubuntu3.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgs8", ver:"8.61.dfsg.1-1ubuntu3.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ghostscript-doc", ver:"8.63.dfsg.1-0ubuntu6.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-common", ver:"8.63.dfsg.1-0ubuntu6.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-gpl", ver:"8.63.dfsg.1-0ubuntu6.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs", ver:"8.63.dfsg.1-0ubuntu6.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgs-esp-dev", ver:"8.63.dfsg.1-0ubuntu6.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-aladdin", ver:"8.63.dfsg.1-0ubuntu6.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-esp-x", ver:"8.63.dfsg.1-0ubuntu6.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gs-esp", ver:"8.63.dfsg.1-0ubuntu6.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ghostscript-x", ver:"8.63.dfsg.1-0ubuntu6.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ghostscript", ver:"8.63.dfsg.1-0ubuntu6.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgs-dev", ver:"8.63.dfsg.1-0ubuntu6.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgs8", ver:"8.63.dfsg.1-0ubuntu6.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"udev", ver:"079-0ubuntu35.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvolume-id-dev", ver:"113-0ubuntu17.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvolume-id0", ver:"113-0ubuntu17.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"udev", ver:"113-0ubuntu17.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"volumeid", ver:"113-0ubuntu17.2", rls:"UBUNTU7.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvolume-id-dev", ver:"117-8ubuntu0.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvolume-id0", ver:"117-8ubuntu0.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"udev", ver:"117-8ubuntu0.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvolume-id-dev", ver:"124-9ubuntu0.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvolume-id0", ver:"124-9ubuntu0.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"udev", ver:"124-9ubuntu0.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
