# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-777-1 (ntp)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64146);
 script_cve_id("CVE-2009-0159", "CVE-2009-1252");
 script_version ("$");
 name = "Ubuntu USN-777-1 (ntp)";
 script_name(name);

 desc = "The remote host is missing an update to ntp
announced via advisory USN-777-1.

Details follow:

A stack-based buffer overflow was discovered in ntpq. If a user were
tricked into connecting to a malicious ntp server, a remote attacker could
cause a denial of service in ntpq, or possibly execute arbitrary code with
the privileges of the user invoking the program. (CVE-2009-0159)

Chris Ries discovered a stack-based overflow in ntp. If ntp was configured
to use autokey, a remote attacker could send a crafted packet to cause a
denial of service, or possible execute arbitrary code. (CVE-2009-1252)

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  ntp                             1:4.2.0a+stable-8.1ubuntu6.2
  ntp-server                      1:4.2.0a+stable-8.1ubuntu6.2

Ubuntu 8.04 LTS:
  ntp                             1:4.2.4p4+dfsg-3ubuntu2.2

Ubuntu 8.10:
  ntp                             1:4.2.4p4+dfsg-6ubuntu2.3

Ubuntu 9.04:
  ntp                             1:4.2.4p4+dfsg-7ubuntu5.1

In general, a standard system upgrade is sufficient to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-777-1

Risk factor : High";

 script_description(desc);

 summary = "Ubuntu USN-777-1 (ntp)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Ubuntu Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ntp-doc", ver:"4.2.0a+stable-8.1ubuntu6.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntp-server", ver:"4.2.0a+stable-8.1ubuntu6.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntp-simple", ver:"4.2.0a+stable-8.1ubuntu6.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntp", ver:"4.2.0a+stable-8.1ubuntu6.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntpdate", ver:"4.2.0a+stable-8.1ubuntu6.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntp-refclock", ver:"4.2.0a+stable-8.1ubuntu6.2", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntp-doc", ver:"4.2.4p4+dfsg-3ubuntu2.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntp", ver:"4.2.4p4+dfsg-3ubuntu2.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntpdate", ver:"4.2.4p4+dfsg-3ubuntu2.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntp-doc", ver:"4.2.4p4+dfsg-6ubuntu2.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntp", ver:"4.2.4p4+dfsg-6ubuntu2.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntpdate", ver:"4.2.4p4+dfsg-6ubuntu2.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntp-doc", ver:"4.2.4p4+dfsg-7ubuntu5.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntp", ver:"4.2.4p4+dfsg-7ubuntu5.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ntpdate", ver:"4.2.4p4+dfsg-7ubuntu5.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
