# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-791-2 (moodle)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64321);
 script_cve_id("CVE-2009-1171");
 script_version ("$");
 name = "Ubuntu USN-791-2 (moodle)";
 script_name(name);

 desc = "The remote host is missing an update to moodle
announced via advisory USN-791-2.

Details follow:

Christian Eibl discovered that the TeX filter in Moodle allowed any
function to be used.  An authenticated remote attacker could post
a specially crafted TeX formula to execute arbitrary TeX functions,
potentially reading any file accessible to the web server user, leading
to a loss of privacy.  (CVE-2009-1171, MSA-09-0009)

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 9.04:
  moodle                          1.9.4.dfsg-0ubuntu1.1

After a standard system upgrade you need to access the Moodle instance
and accept the database update to clear any invalid cached data.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-791-2

Risk factor : High";

 script_description(desc);

 summary = "Ubuntu USN-791-2 (moodle)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Ubuntu Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"moodle", ver:"1.9.4.dfsg-0ubuntu1.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
