# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-796-1 (pidgin)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64382);
 script_cve_id("CVE-2009-1889");
 script_version ("$");
 name = "Ubuntu USN-796-1 (pidgin)";
 script_name(name);

 desc = "The remote host is missing an update to pidgin
announced via advisory USN-796-1.

Details follow:

Yuriy Kaminskiy discovered that Pidgin did not properly handle certain
messages in the ICQ protocol handler. A remote attacker could send a
specially crafted message and cause Pidgin to crash.

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 8.04 LTS:
  pidgin                          1:2.4.1-1ubuntu2.5

Ubuntu 8.10:
  pidgin                          1:2.5.2-0ubuntu1.3

Ubuntu 9.04:
  pidgin                          1:2.5.5-1ubuntu8.3

After a standard system upgrade you need to restart Pidgin to effect
the necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-796-1

Risk factor : High";

 script_description(desc);

 summary = "Ubuntu USN-796-1 (pidgin)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Ubuntu Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"finch-dev", ver:"2.4.1-1ubuntu2.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpurple-bin", ver:"2.4.1-1ubuntu2.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpurple-dev", ver:"2.4.1-1ubuntu2.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pidgin-data", ver:"2.4.1-1ubuntu2.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pidgin-dev", ver:"2.4.1-1ubuntu2.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gaim", ver:"2.4.1-1ubuntu2.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"finch", ver:"2.4.1-1ubuntu2.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpurple0", ver:"2.4.1-1ubuntu2.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pidgin-dbg", ver:"2.4.1-1ubuntu2.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pidgin", ver:"2.4.1-1ubuntu2.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"finch-dev", ver:"2.5.2-0ubuntu1.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpurple-bin", ver:"2.5.2-0ubuntu1.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpurple-dev", ver:"2.5.2-0ubuntu1.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pidgin-data", ver:"2.5.2-0ubuntu1.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pidgin-dev", ver:"2.5.2-0ubuntu1.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"finch", ver:"2.5.2-0ubuntu1.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpurple0", ver:"2.5.2-0ubuntu1.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pidgin-dbg", ver:"2.5.2-0ubuntu1.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pidgin", ver:"2.5.2-0ubuntu1.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"finch-dev", ver:"2.5.5-1ubuntu8.3", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpurple-bin", ver:"2.5.5-1ubuntu8.3", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpurple-dev", ver:"2.5.5-1ubuntu8.3", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pidgin-data", ver:"2.5.5-1ubuntu8.3", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pidgin-dev", ver:"2.5.5-1ubuntu8.3", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"finch", ver:"2.5.5-1ubuntu8.3", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpurple0", ver:"2.5.5-1ubuntu8.3", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pidgin-dbg", ver:"2.5.5-1ubuntu8.3", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pidgin", ver:"2.5.5-1ubuntu8.3", rls:"UBUNTU9.04")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
