# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-801-1 (tiff)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64442);
 script_cve_id("CVE-2009-2347", "CVE-2009-1890", "CVE-2009-1891", "CVE-2008-2327", "CVE-2009-2285", "CVE-2009-2295", "CVE-2009-0858", "CVE-2009-2334", "CVE-2009-2335", "CVE-2009-2336", "CVE-2008-0196", "CVE-2009-2360", "CVE-2009-0040", "CVE-2009-0352", "CVE-2009-0353", "CVE-2009-0652", "CVE-2009-0771", "CVE-2009-0772", "CVE-2009-0773", "CVE-2009-0774", "CVE-2009-0776", "CVE-2009-1302", "CVE-2009-1303", "CVE-2009-1307", "CVE-2009-1832", "CVE-2009-1392", "CVE-2009-1836", "CVE-2009-1838", "CVE-2009-1841", "CVE-2009-1185", "CVE-2009-0034", "CVE-2009-0037", "CVE-2009-1422", "CVE-2009-1423", "CVE-2009-1424", "CVE-2009-1425", "CVE-2009-1959");
 script_version ("$");
 name = "Ubuntu USN-801-1 (tiff)";
 script_name(name);

 desc = "The remote host is missing an update to tiff
announced via advisory USN-801-1.

Details follow:

Tielei Wang and Tom Lane discovered that the TIFF library did not correctly
handle certain malformed TIFF images. If a user or automated system were
tricked into processing a malicious image, an attacker could execute
arbitrary code with the privileges of the user invoking the program.

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  libtiff4                        3.7.4-1ubuntu3.6

Ubuntu 8.04 LTS:
  libtiff4                        3.8.2-7ubuntu3.4

Ubuntu 8.10:
  libtiff4                        3.8.2-11ubuntu0.8.10.3

Ubuntu 9.04:
  libtiff4                        3.8.2-11ubuntu0.9.04.3

In general, a standard system upgrade is sufficient to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-801-1

Risk factor : High";

 script_description(desc);

 summary = "Ubuntu USN-801-1 (tiff)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Ubuntu Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libtiff-tools", ver:"3.7.4-1ubuntu3.6", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff4-dev", ver:"3.7.4-1ubuntu3.6", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff4", ver:"3.7.4-1ubuntu3.6", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiffxx0c2", ver:"3.7.4-1ubuntu3.6", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff-opengl", ver:"3.7.4-1ubuntu3.6", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff-tools", ver:"3.8.2-7ubuntu3.4", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff4-dev", ver:"3.8.2-7ubuntu3.4", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff4", ver:"3.8.2-7ubuntu3.4", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiffxx0c2", ver:"3.8.2-7ubuntu3.4", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff-opengl", ver:"3.8.2-7ubuntu3.4", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff-doc", ver:"3.8.2-11ubuntu0.8.10.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff4-dev", ver:"3.8.2-11ubuntu0.8.10.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff4", ver:"3.8.2-11ubuntu0.8.10.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiffxx0c2", ver:"3.8.2-11ubuntu0.8.10.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff-opengl", ver:"3.8.2-11ubuntu0.8.10.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff-tools", ver:"3.8.2-11ubuntu0.8.10.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff-doc", ver:"3.8.2-11ubuntu0.9.04.3", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff-tools", ver:"3.8.2-11ubuntu0.9.04.3", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff4-dev", ver:"3.8.2-11ubuntu0.9.04.3", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff4", ver:"3.8.2-11ubuntu0.9.04.3", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiffxx0c2", ver:"3.8.2-11ubuntu0.9.04.3", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libtiff-opengl", ver:"3.8.2-11ubuntu0.9.04.3", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-doc", ver:"2.0.55-4ubuntu2.6", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-common", ver:"2.0.55-4ubuntu2.6", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-perchild", ver:"2.0.55-4ubuntu2.6", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-prefork", ver:"2.0.55-4ubuntu2.6", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-worker", ver:"2.0.55-4ubuntu2.6", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-prefork-dev", ver:"2.0.55-4ubuntu2.6", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-threaded-dev", ver:"2.0.55-4ubuntu2.6", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-utils", ver:"2.0.55-4ubuntu2.6", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2", ver:"2.0.55-4ubuntu2.6", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapr0-dev", ver:"2.0.55-4ubuntu2.6", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapr0", ver:"2.0.55-4ubuntu2.6", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-doc", ver:"2.2.8-1ubuntu0.10", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-perchild", ver:"2.2.8-1ubuntu0.10", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-src", ver:"2.2.8-1ubuntu0.10", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2", ver:"2.2.8-1ubuntu0.10", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-event", ver:"2.2.8-1ubuntu0.10", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-prefork", ver:"2.2.8-1ubuntu0.10", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-worker", ver:"2.2.8-1ubuntu0.10", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-prefork-dev", ver:"2.2.8-1ubuntu0.10", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-threaded-dev", ver:"2.2.8-1ubuntu0.10", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-utils", ver:"2.2.8-1ubuntu0.10", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2.2-common", ver:"2.2.8-1ubuntu0.10", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-doc", ver:"2.2.9-7ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-src", ver:"2.2.9-7ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2", ver:"2.2.9-7ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-event", ver:"2.2.9-7ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-prefork", ver:"2.2.9-7ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-worker", ver:"2.2.9-7ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-prefork-dev", ver:"2.2.9-7ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-suexec-custom", ver:"2.2.9-7ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-suexec", ver:"2.2.9-7ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-threaded-dev", ver:"2.2.9-7ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-utils", ver:"2.2.9-7ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2.2-common", ver:"2.2.9-7ubuntu3.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-doc", ver:"2.2.11-2ubuntu2.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2", ver:"2.2.11-2ubuntu2.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-src", ver:"2.2.11-2ubuntu2.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-event", ver:"2.2.11-2ubuntu2.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-prefork", ver:"2.2.11-2ubuntu2.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-mpm-worker", ver:"2.2.11-2ubuntu2.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-prefork-dev", ver:"2.2.11-2ubuntu2.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-threaded-dev", ver:"2.2.11-2ubuntu2.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-utils", ver:"2.2.11-2ubuntu2.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2.2-common", ver:"2.2.11-2ubuntu2.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-suexec-custom", ver:"2.2.11-2ubuntu2.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"apache2-suexec", ver:"2.2.11-2ubuntu2.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcamlimages-ocaml-doc", ver:"2.2.0-4+lenny1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcamlimages-ocaml-dev", ver:"2.2.0-4+lenny1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcamlimages-ocaml", ver:"2.2.0-4+lenny1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"dnscache-run", ver:"1.05-4+lenny1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"djbdns", ver:"1.05-4+lenny1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"dbndns", ver:"1.05-4+lenny1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"sork-passwd-h3", ver:"3.0-2+lenny1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"icedove", ver:"2.0.0.22-0lenny1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"icedove-dbg", ver:"2.0.0.22-0lenny1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"icedove-gnome-support", ver:"2.0.0.22-0lenny1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"icedove-dev", ver:"2.0.0.22-0lenny1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"irssi-dev", ver:"0.8.10-1ubuntu1.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"irssi-text", ver:"0.8.10-1ubuntu1.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"irssi", ver:"0.8.10-1ubuntu1.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"irssi-dev", ver:"0.8.12-3ubuntu3.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"irssi", ver:"0.8.12-3ubuntu3.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"irssi-dev", ver:"0.8.12-4ubuntu2.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"irssi", ver:"0.8.12-4ubuntu2.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"irssi-dev", ver:"0.8.12-6ubuntu1.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"irssi", ver:"0.8.12-6ubuntu1.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
