# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-804-1 (pulseaudio)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64445);
 script_cve_id("CVE-2009-1894");
 script_version ("$");
 name = "Ubuntu USN-804-1 (pulseaudio)";
 script_name(name);

 desc = "The remote host is missing an update to pulseaudio
announced via advisory USN-804-1.

Details follow:

Tavis Ormandy and Yorick Koster discovered that PulseAudio did not
safely re-execute itself.  A local attacker could exploit this to gain
root privileges.

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 8.04 LTS:
  pulseaudio                      0.9.10-1ubuntu1.1

Ubuntu 8.10:
  pulseaudio                      0.9.10-2ubuntu9.4

Ubuntu 9.04:
  pulseaudio                      1:0.9.14-0ubuntu20.2

In general, a standard system upgrade is sufficient to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-804-1

Risk factor : High";

 script_description(desc);

 summary = "Ubuntu USN-804-1 (pulseaudio)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Ubuntu Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libpulse-browse0-dbg", ver:"0.9.10-1ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse-browse0", ver:"0.9.10-1ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse-dev", ver:"0.9.10-1ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse-mainloop-glib0-dbg", ver:"0.9.10-1ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse-mainloop-glib0", ver:"0.9.10-1ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse0-dbg", ver:"0.9.10-1ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse0", ver:"0.9.10-1ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulsecore5-dbg", ver:"0.9.10-1ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulsecore5", ver:"0.9.10-1ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-dbg", ver:"0.9.10-1ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-esound-compat-dbg", ver:"0.9.10-1ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-esound-compat", ver:"0.9.10-1ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-gconf-dbg", ver:"0.9.10-1ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-gconf", ver:"0.9.10-1ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-hal-dbg", ver:"0.9.10-1ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-hal", ver:"0.9.10-1ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-lirc-dbg", ver:"0.9.10-1ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-lirc", ver:"0.9.10-1ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-x11-dbg", ver:"0.9.10-1ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-x11", ver:"0.9.10-1ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-zeroconf-dbg", ver:"0.9.10-1ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-zeroconf", ver:"0.9.10-1ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-utils-dbg", ver:"0.9.10-1ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-utils", ver:"0.9.10-1ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio", ver:"0.9.10-1ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse-browse0-dbg", ver:"0.9.10-2ubuntu9.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse-browse0", ver:"0.9.10-2ubuntu9.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse-dev", ver:"0.9.10-2ubuntu9.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse-mainloop-glib0-dbg", ver:"0.9.10-2ubuntu9.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse-mainloop-glib0", ver:"0.9.10-2ubuntu9.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse0-dbg", ver:"0.9.10-2ubuntu9.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse0", ver:"0.9.10-2ubuntu9.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulsecore5-dbg", ver:"0.9.10-2ubuntu9.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulsecore5", ver:"0.9.10-2ubuntu9.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-dbg", ver:"0.9.10-2ubuntu9.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-esound-compat-dbg", ver:"0.9.10-2ubuntu9.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-esound-compat", ver:"0.9.10-2ubuntu9.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-gconf-dbg", ver:"0.9.10-2ubuntu9.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-gconf", ver:"0.9.10-2ubuntu9.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-hal-dbg", ver:"0.9.10-2ubuntu9.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-hal", ver:"0.9.10-2ubuntu9.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-lirc-dbg", ver:"0.9.10-2ubuntu9.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-lirc", ver:"0.9.10-2ubuntu9.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-x11-dbg", ver:"0.9.10-2ubuntu9.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-x11", ver:"0.9.10-2ubuntu9.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-zeroconf-dbg", ver:"0.9.10-2ubuntu9.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-zeroconf", ver:"0.9.10-2ubuntu9.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-utils-dbg", ver:"0.9.10-2ubuntu9.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-utils", ver:"0.9.10-2ubuntu9.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio", ver:"0.9.10-2ubuntu9.4", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse-browse0-dbg", ver:"0.9.14-0ubuntu20.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse-browse0", ver:"0.9.14-0ubuntu20.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse-dev", ver:"0.9.14-0ubuntu20.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse-mainloop-glib0-dbg", ver:"0.9.14-0ubuntu20.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse-mainloop-glib0", ver:"0.9.14-0ubuntu20.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse0-dbg", ver:"0.9.14-0ubuntu20.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulse0", ver:"0.9.14-0ubuntu20.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulsecore9-dbg", ver:"0.9.14-0ubuntu20.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpulsecore9", ver:"0.9.14-0ubuntu20.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-dbg", ver:"0.9.14-0ubuntu20.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-esound-compat-dbg", ver:"0.9.14-0ubuntu20.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-esound-compat", ver:"0.9.14-0ubuntu20.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-gconf-dbg", ver:"0.9.14-0ubuntu20.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-gconf", ver:"0.9.14-0ubuntu20.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-hal-dbg", ver:"0.9.14-0ubuntu20.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-hal", ver:"0.9.14-0ubuntu20.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-lirc-dbg", ver:"0.9.14-0ubuntu20.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-lirc", ver:"0.9.14-0ubuntu20.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-x11-dbg", ver:"0.9.14-0ubuntu20.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-x11", ver:"0.9.14-0ubuntu20.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-zeroconf-dbg", ver:"0.9.14-0ubuntu20.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-module-zeroconf", ver:"0.9.14-0ubuntu20.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-utils-dbg", ver:"0.9.14-0ubuntu20.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio-utils", ver:"0.9.14-0ubuntu20.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"pulseaudio", ver:"0.9.14-0ubuntu20.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
