# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-815-1 (libxml2)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64649);
 script_cve_id("CVE-2008-3529", "CVE-2009-2414", "CVE-2009-2416");
 script_version ("$Revision$");
 script_name("Ubuntu USN-815-1 (libxml2)");

 desc = "The remote host is missing an update to libxml2
announced via advisory USN-815-1.

Details follow:

It was discovered that libxml2 did not correctly handle root XML document
element DTD definitions. If a user were tricked into processing a specially
crafted XML document, a remote attacker could cause the application linked
against libxml2 to crash, leading to a denial of service. (CVE-2009-2414)

It was discovered that libxml2 did not correctly parse Notation and
Enumeration attribute types. If a user were tricked into processing a
specially crafted XML document, a remote attacker could cause the
application linked against libxml2 to crash, leading to a denial of
service. (CVE-2009-2416)

USN-644-1 fixed a vulnerability in libxml2. This advisory provides the
corresponding update for Ubuntu 9.04.

Original advisory details:

 It was discovered that libxml2 did not correctly handle long entity names.
 If a user were tricked into processing a specially crafted XML document, a
 remote attacker could execute arbitrary code with user privileges or cause
 the application linked against libxml2 to crash, leading to a denial of
 service. (CVE-2008-3529)

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  libxml2                         2.6.24.dfsg-1ubuntu1.5

Ubuntu 8.04 LTS:
  libxml2                         2.6.31.dfsg-2ubuntu1.4

Ubuntu 8.10:
  libxml2                         2.6.32.dfsg-4ubuntu1.2

Ubuntu 9.04:
  libxml2                         2.6.32.dfsg-5ubuntu4.2

After a standard system upgrade you need to restart your sessions to effect
the necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-815-1

Risk factor : High";

 script_description(desc);

 script_summary("Ubuntu USN-815-1 (libxml2)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Ubuntu Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libxml2-doc", ver:"2.6.24.dfsg-1ubuntu1.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-libxml2", ver:"2.6.24.dfsg-1ubuntu1.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-dbg", ver:"2.6.24.dfsg-1ubuntu1.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-dev", ver:"2.6.24.dfsg-1ubuntu1.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-utils", ver:"2.6.24.dfsg-1ubuntu1.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2", ver:"2.6.24.dfsg-1ubuntu1.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python2.4-libxml2", ver:"2.6.24.dfsg-1ubuntu1.5", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-doc", ver:"2.6.31.dfsg-2ubuntu1.4", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-dbg", ver:"2.6.31.dfsg-2ubuntu1.4", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-dev", ver:"2.6.31.dfsg-2ubuntu1.4", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-utils", ver:"2.6.31.dfsg-2ubuntu1.4", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2", ver:"2.6.31.dfsg-2ubuntu1.4", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-libxml2-dbg", ver:"2.6.31.dfsg-2ubuntu1.4", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-libxml2", ver:"2.6.31.dfsg-2ubuntu1.4", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-doc", ver:"2.6.32.dfsg-4ubuntu1.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-dbg", ver:"2.6.32.dfsg-4ubuntu1.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-dev", ver:"2.6.32.dfsg-4ubuntu1.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-utils", ver:"2.6.32.dfsg-4ubuntu1.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2", ver:"2.6.32.dfsg-4ubuntu1.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-libxml2-dbg", ver:"2.6.32.dfsg-4ubuntu1.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-libxml2", ver:"2.6.32.dfsg-4ubuntu1.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-doc", ver:"2.6.32.dfsg-5ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-dbg", ver:"2.6.32.dfsg-5ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-dev", ver:"2.6.32.dfsg-5ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2-utils", ver:"2.6.32.dfsg-5ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libxml2", ver:"2.6.32.dfsg-5ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-libxml2-dbg", ver:"2.6.32.dfsg-5ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-libxml2", ver:"2.6.32.dfsg-5ubuntu4.2", rls:"UBUNTU9.04")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
