# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-836-1 (webkit)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64983);
 script_cve_id("CVE-2009-0945", "CVE-2009-1687", "CVE-2009-1690", "CVE-2009-1698", "CVE-2009-1711", "CVE-2009-1712", "CVE-2009-1725");
 script_version ("$");
 script_name("Ubuntu USN-836-1 (webkit)");

 desc = "The remote host is missing an update to webkit
announced via advisory USN-836-1.

Details follow:

It was discovered that WebKit did not properly handle certain SVGPathList
data structures. If a user were tricked into viewing a malicious website,
an attacker could exploit this to execute arbitrary code with the
privileges of the user invoking the program. (CVE-2009-0945)

Several flaws were discovered in the WebKit browser and JavaScript engines.
If a user were tricked into viewing a malicious website, a remote attacker
could cause a denial of service or possibly execute arbitrary code with the
privileges of the user invoking the program. (CVE-2009-1687, CVE-2009-1690,
CVE-2009-1698, CVE-2009-1711, CVE-2009-1725)

It was discovered that WebKit did not prevent the loading of local Java
applets. If a user were tricked into viewing a malicious website,
an attacker could exploit this to execute arbitrary code with the
privileges of the user invoking the program. (CVE-2009-1712)

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 8.10:
  libwebkit-1.0-1                 1.0.1-2ubuntu0.2
  libwebkit-1.0-1-dbg             1.0.1-2ubuntu0.2
  libwebkit-dev                   1.0.1-2ubuntu0.2

Ubuntu 9.04:
  libwebkit-1.0-1                 1.0.1-4ubuntu0.1
  libwebkit-1.0-1-dbg             1.0.1-4ubuntu0.1
  libwebkit-dev                   1.0.1-4ubuntu0.1

After a standard system upgrade you need to restart any applications that
use WebKit, such as Epiphany-webkit and Midori, to effect the necessary
changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-836-1

Risk factor : High";

 script_description(desc);

 script_summary("Ubuntu USN-836-1 (webkit)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Ubuntu Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libwebkit-dev", ver:"1.0.1-2ubuntu0.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libwebkit-1.0-1-dbg", ver:"1.0.1-2ubuntu0.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libwebkit-1.0-1", ver:"1.0.1-2ubuntu0.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libwebkit-dev", ver:"1.0.1-4ubuntu0.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libwebkit-1.0-1-dbg", ver:"1.0.1-4ubuntu0.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libwebkit-1.0-1", ver:"1.0.1-4ubuntu0.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
