# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-837-1 (newt)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64984);
 script_cve_id("CVE-2009-2905");
 script_version ("$");
 script_name("Ubuntu USN-837-1 (newt)");

 desc = "The remote host is missing an update to newt
announced via advisory USN-837-1.

Details follow:

Miroslav Lichvar discovered that Newt incorrectly handled rendering in a
text box. An attacker could exploit this and cause a denial of service or
possibly execute arbitrary code with the privileges of the user invoking
the program.

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  libnewt0.51                     0.51.6-31ubuntu1.1

Ubuntu 8.04 LTS:
  libnewt0.52                     0.52.2-11.2ubuntu1.1

Ubuntu 8.10:
  libnewt0.52                     0.52.2-11.3ubuntu1.1

Ubuntu 9.04:
  libnewt0.52                     0.52.2-11.3ubuntu3.1

In general, a standard system upgrade is sufficient to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-837-1

Risk factor : High";

 script_description(desc);

 script_summary("Ubuntu USN-837-1 (newt)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Ubuntu Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libnewt-dev", ver:"0.51.6-31ubuntu1.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnewt-pic", ver:"0.51.6-31ubuntu1.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnewt0.51", ver:"0.51.6-31ubuntu1.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-newt", ver:"0.51.6-31ubuntu1.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"whiptail", ver:"0.51.6-31ubuntu1.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"newt-tcl", ver:"0.51.6-31ubuntu1.1", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnewt-dev", ver:"0.52.2-11.2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnewt-pic", ver:"0.52.2-11.2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnewt0.52", ver:"0.52.2-11.2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-newt-dbg", ver:"0.52.2-11.2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-newt", ver:"0.52.2-11.2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"whiptail", ver:"0.52.2-11.2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"newt-tcl", ver:"0.52.2-11.2ubuntu1.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnewt-dev", ver:"0.52.2-11.3ubuntu1.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnewt-pic", ver:"0.52.2-11.3ubuntu1.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnewt0.52", ver:"0.52.2-11.3ubuntu1.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-newt-dbg", ver:"0.52.2-11.3ubuntu1.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-newt", ver:"0.52.2-11.3ubuntu1.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"whiptail", ver:"0.52.2-11.3ubuntu1.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"newt-tcl", ver:"0.52.2-11.3ubuntu1.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnewt-dev", ver:"0.52.2-11.3ubuntu3.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnewt-pic", ver:"0.52.2-11.3ubuntu3.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnewt0.52", ver:"0.52.2-11.3ubuntu3.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-newt-dbg", ver:"0.52.2-11.3ubuntu3.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"python-newt", ver:"0.52.2-11.3ubuntu3.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"whiptail", ver:"0.52.2-11.3ubuntu3.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"newt-tcl", ver:"0.52.2-11.3ubuntu3.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
